/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.http.server;

import com.google.common.io.Closer;
import com.spotify.apollo.http.server.ApolloRequestHandler;
import com.spotify.apollo.http.server.HttpServer;
import com.spotify.apollo.http.server.HttpServerConfig;
import com.spotify.apollo.request.RequestHandler;
import com.spotify.apollo.request.ServerInfo;
import com.spotify.apollo.request.ServerInfos;
import java.net.InetSocketAddress;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpServerImpl
implements HttpServer {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServer.class);
    private static final String SERVER_ID = "http";
    private final Closer closer;
    private final HttpServerConfig config;
    private final Runnable onClose;
    private Server server;

    HttpServerImpl(Closer closer, HttpServerConfig config, Runnable onClose) {
        this.closer = closer;
        this.config = config;
        this.onClose = onClose;
    }

    @Override
    public void start(RequestHandler requestHandler) {
        LOG.info("Starting Jetty HTTP server on {}:{}", (Object)this.config.address(), (Object)this.config.port());
        InetSocketAddress serverSocketAddress = new InetSocketAddress(this.config.address(), (int)this.config.port());
        ServerInfo serverInfo = ServerInfos.create((String)SERVER_ID, (InetSocketAddress)serverSocketAddress);
        this.server = new Server(serverSocketAddress);
        this.server.setHandler((Handler)new ApolloRequestHandler(serverInfo, requestHandler));
        try {
            this.server.start();
            this.closer.register(this::close);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start server", e);
        }
    }

    @Override
    public void close() {
        try {
            this.server.stop();
            if (this.onClose != null) {
                this.onClose.run();
            }
        }
        catch (Exception e) {
            LOG.warn("Could not close jetty http server", (Throwable)e);
        }
    }
}

