/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.http.server;

import com.google.common.io.Closer;
import com.google.inject.Inject;
import com.spotify.apollo.http.server.HttpServer;
import com.spotify.apollo.http.server.HttpServerConfig;
import com.spotify.apollo.http.server.HttpServerImpl;
import com.spotify.apollo.request.RequestHandler;
import java.io.IOException;
import javax.inject.Named;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpServerProvider
implements Provider<HttpServer> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServerProvider.class);
    private final Closer closer;
    private final HttpServerConfig config;
    private final Runnable onClose;

    @Inject
    HttpServerProvider(Closer closer, HttpServerConfig config, @Named(value="http-server-on-close") Runnable onClose) {
        this.closer = closer;
        this.config = config;
        this.onClose = onClose;
    }

    public HttpServer get() {
        if (!HttpServerProvider.enabled(this.config)) {
            return NoopServer.INSTANCE;
        }
        return new HttpServerImpl(this.closer, this.config, this.onClose);
    }

    static boolean enabled(HttpServerConfig config) {
        return config.port() != null;
    }

    private static enum NoopServer implements HttpServer
    {
        INSTANCE;


        @Override
        public void start(RequestHandler requestHandler) {
            LOG.warn("Not loading http server - enable with: http.server.port = 8080");
        }

        @Override
        public void close() throws IOException {
        }
    }
}

