/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.http.client;

import com.spotify.apollo.Request;
import com.spotify.apollo.Response;
import com.spotify.apollo.environment.IncomingRequestAwareClient;
import com.spotify.apollo.http.client.TransformingCallback;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import okio.ByteString;

class HttpClient
implements IncomingRequestAwareClient {
    private static final MediaType DEFAULT_CONTENT_TYPE = MediaType.parse((String)"application/octet-stream");
    private final OkHttpClient client;

    HttpClient(OkHttpClient client) {
        this.client = client;
    }

    public static HttpClient create() {
        return new HttpClient(new OkHttpClient());
    }

    public CompletionStage<Response<ByteString>> send(Request apolloRequest, Optional<Request> apolloIncomingRequest) {
        Optional<RequestBody> requestBody = apolloRequest.payload().map(payload -> {
            MediaType contentType = apolloRequest.header("Content-Type").map(MediaType::parse).orElse(DEFAULT_CONTENT_TYPE);
            return RequestBody.create((MediaType)contentType, (ByteString)payload);
        });
        com.squareup.okhttp.Request request = new Request.Builder().method(apolloRequest.method(), (RequestBody)requestBody.orElse(null)).url(apolloRequest.uri()).build();
        CompletableFuture<Response<ByteString>> result = new CompletableFuture<Response<ByteString>>();
        this.client.newCall(request).enqueue((Callback)TransformingCallback.create(result));
        return result;
    }
}

