/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.http.client;

import com.google.common.base.Joiner;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Request;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okio.ByteString;

class TransformingCallback
implements Callback {
    private static final Joiner HEADER_JOINER = Joiner.on((String)", ");
    private final CompletableFuture<Response<ByteString>> future;

    TransformingCallback(CompletableFuture<Response<ByteString>> future) {
        this.future = future;
    }

    public static TransformingCallback create(CompletableFuture<Response<ByteString>> future) {
        return new TransformingCallback(future);
    }

    public void onFailure(Request request, IOException e) {
        String message = MessageFormat.format("Request {0} failed", request);
        IOException exception = new IOException(message, e);
        this.future.completeExceptionally(exception);
    }

    public void onResponse(com.squareup.okhttp.Response response) throws IOException {
        this.future.complete(TransformingCallback.transformResponse(response));
    }

    static Response<ByteString> transformResponse(com.squareup.okhttp.Response response) throws IOException {
        StatusType status = TransformingCallback.transformStatus(response.code(), Optional.ofNullable(response.message()));
        Response apolloResponse = Response.forStatus((StatusType)status);
        for (Map.Entry entry : response.headers().toMultimap().entrySet()) {
            apolloResponse = apolloResponse.withHeader((String)entry.getKey(), HEADER_JOINER.join((Iterable)entry.getValue()));
        }
        byte[] bytes = response.body().bytes();
        if (bytes.length > 0) {
            apolloResponse = apolloResponse.withPayload((Object)ByteString.of((byte[])bytes));
        }
        return apolloResponse;
    }

    static StatusType transformStatus(int code, Optional<String> message) {
        StatusType statusType = Status.createForCode((int)code);
        if (message.isPresent() && !message.get().equals(statusType.reasonPhrase())) {
            return statusType.withReasonPhrase(message.get());
        }
        return statusType;
    }
}

