/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.route;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.norberg.rut.Route;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Rule<T> {
    private final List<String> methods;
    private final String path;
    private final T target;
    private final int extractionCount;

    private Rule(String uri, String method, T target) {
        this(uri, Collections.singletonList(method), target);
    }

    private Rule(String uri, List<String> methods, T target) {
        this.path = uri;
        this.target = target;
        this.methods = Rule.processMethods(methods);
        Route route = Route.of((CharSequence)"HEAD", (CharSequence)uri);
        Set<String> duplicateNames = Rule.duplicates(route.captureNames());
        if (!duplicateNames.isEmpty()) {
            throw new IllegalArgumentException("duplicate extraction names: " + Joiner.on((char)',').join(duplicateNames));
        }
        this.extractionCount = route.captureNames().size();
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public String getPath() {
        return this.path;
    }

    public T getTarget() {
        return this.target;
    }

    private static ImmutableList<String> processMethods(List<String> methods) {
        ImmutableList.Builder builder = ImmutableList.builder().addAll(methods);
        if (methods.contains("GET")) {
            builder.add((Object)"HEAD");
        }
        return builder.build();
    }

    public static <T> Rule<T> fromUri(String uri, List<String> methods, T target) {
        return new Rule<T>(uri, methods, target);
    }

    public static <T> Rule<T> fromUri(String uri, String methods, T target) {
        return new Rule<T>(uri, Collections.singletonList(methods), target);
    }

    public int getExtractionCount() {
        return this.extractionCount;
    }

    private static Set<String> duplicates(List<String> strings) {
        HashSet duplicates = Sets.newHashSet();
        HashSet unique = Sets.newHashSet();
        for (String string : strings) {
            if (unique.contains(string)) {
                duplicates.add(string);
            }
            unique.add(string);
        }
        return duplicates;
    }
}

