/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.route;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.spotify.apollo.Request;
import com.spotify.apollo.route.ApplicationRouter;
import com.spotify.apollo.route.InvalidUriException;
import com.spotify.apollo.route.Rule;
import com.spotify.apollo.route.RuleMatch;
import io.norberg.rut.Router;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleRouter<T>
implements ApplicationRouter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RuleRouter.class);
    private final List<Rule<T>> rules;
    private final Router<Rule<T>> router;

    private RuleRouter(Iterable<Rule<T>> rules) {
        this.rules = ImmutableList.copyOf(rules);
        this.router = RuleRouter.router(rules);
    }

    @Override
    public Optional<RuleMatch<T>> match(Request message) throws InvalidUriException {
        String method = message.method();
        String path = this.getPath(message);
        if (method == null || path == null) {
            LOG.warn("Invalid URI sent {} {} by service {}", new Object[]{message.method(), message.uri(), message.service()});
            throw new InvalidUriException();
        }
        Router.Result result = this.router.result();
        this.router.route((CharSequence)method, (CharSequence)path, result);
        if (!result.isSuccess()) {
            return Optional.empty();
        }
        Rule rule = (Rule)result.target();
        ImmutableMap.Builder pathArgs = ImmutableMap.builder();
        for (int i = 0; i < result.params(); ++i) {
            pathArgs.put((Object)result.paramName(i), (Object)this.readParameterValue(result, i));
        }
        return Optional.of(new RuleMatch(rule, (Map<String, String>)pathArgs.build()));
    }

    private String readParameterValue(Router.Result<Rule<T>> result, int i) {
        switch (result.paramType(i)) {
            case SEGMENT: {
                return result.paramValueDecoded(i).toString();
            }
            case PATH: {
                return result.paramValue(i).toString();
            }
        }
        LOG.error("Unknown rut parameter type {}, URI-decoding parameter value (raw {}, decoded {})", new Object[]{result.paramType(i), result.paramValue(i), result.paramValueDecoded(i)});
        return result.paramValueDecoded(i).toString();
    }

    @Override
    public Collection<String> getMethodsForValidRules(Request message) {
        String path = this.getPath(message);
        Router.Result result = this.router.result();
        this.router.route((CharSequence)message.method(), (CharSequence)path, result);
        if (result.status() == Router.Status.NOT_FOUND) {
            return Collections.emptyList();
        }
        return result.allowedMethods();
    }

    @Override
    public List<T> getRuleTargets() {
        ArrayList targets = Lists.newArrayListWithCapacity((int)this.rules.size());
        for (Rule<T> rule : this.rules) {
            targets.add(rule.getTarget());
        }
        return targets;
    }

    private String getPath(Request message) {
        try {
            URI uri = new URI(message.uri());
            return uri.getRawPath();
        }
        catch (URISyntaxException e) {
            LOG.warn("Invalid URI sent {} {} by service {}", new Object[]{message.method(), message.uri(), message.service(), e});
            return null;
        }
    }

    public static <T> RuleRouter<T> of(Iterable<Rule<T>> rules) {
        return new RuleRouter<T>(ImmutableList.copyOf(rules));
    }

    private static <T> Router<Rule<T>> router(Iterable<Rule<T>> rules) {
        Router.Builder b = Router.builder();
        b.optionalTrailingSlash(true);
        for (Rule<T> rule : rules) {
            for (String method : rule.getMethods()) {
                b.route(method, rule.getPath(), rule);
            }
        }
        return b.build();
    }
}

