/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.google.common.util.concurrent.MoreExecutors;
import com.spotify.google.cloud.pubsub.client.Backoff;
import com.spotify.google.cloud.pubsub.client.Pubsub;
import com.spotify.google.cloud.pubsub.client.PubsubFuture;
import com.spotify.google.cloud.pubsub.client.QueueFullException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class Acker
implements Closeable {
    private final ScheduledExecutorService scheduler = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1));
    private final AtomicInteger size = new AtomicInteger();
    private final ConcurrentLinkedQueue<QueuedAck> queue = new ConcurrentLinkedQueue();
    private final AtomicBoolean scheduled = new AtomicBoolean();
    private final AtomicInteger outstanding = new AtomicInteger();
    private final AtomicBoolean sending = new AtomicBoolean();
    private final Pubsub pubsub;
    private final String project;
    private final String subscription;
    private final int batchSize;
    private final int queueSize;
    private final long maxLatencyMs;
    private final int concurrency;
    private final Backoff backoff;

    private Acker(Builder builder) {
        this.pubsub = Objects.requireNonNull(builder.pubsub, "pubsub");
        this.project = Objects.requireNonNull(builder.project, "project");
        this.subscription = Objects.requireNonNull(builder.subscription, "subscription");
        this.batchSize = builder.batchSize;
        this.queueSize = Optional.ofNullable(builder.queueSize).orElseGet(() -> this.batchSize * 10);
        this.maxLatencyMs = builder.maxLatencyMs;
        this.concurrency = builder.concurrency;
        this.backoff = Backoff.builder().initialInterval(builder.maxLatencyMs).maxBackoffMultiplier(builder.maxBackoffMultiplier).build();
    }

    public CompletableFuture<Void> acknowledge(String ackId) {
        int newSize;
        int currentSize;
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        do {
            if ((newSize = (currentSize = this.size.get()) + 1) <= this.queueSize) continue;
            future.completeExceptionally(new QueueFullException());
            return future;
        } while (!this.size.compareAndSet(currentSize, newSize));
        this.queue.add(new QueuedAck(ackId, future));
        if (newSize >= this.batchSize) {
            this.send();
            return future;
        }
        if (this.scheduled.compareAndSet(false, true)) {
            try {
                this.scheduler.schedule(this::scheduledSend, this.maxLatencyMs, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        return future;
    }

    private void scheduledSend() {
        this.scheduled.set(false);
        this.send();
    }

    private void send() {
        if (this.sending.compareAndSet(false, true)) {
            try {
                while (this.size.get() > 0 && this.outstanding.get() < this.concurrency) {
                    int sent = this.sendBatch();
                    if (sent != 0) continue;
                    return;
                }
            }
            finally {
                this.sending.set(false);
            }
        }
    }

    private int sendBatch() {
        QueuedAck ack;
        ArrayList<String> batch = new ArrayList<String>();
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        while (batch.size() < this.batchSize && (ack = this.queue.poll()) != null) {
            batch.add(ack.ackId);
            futures.add(ack.future);
        }
        if (batch.size() == 0) {
            return 0;
        }
        this.size.updateAndGet(i -> i - batch.size());
        this.outstanding.incrementAndGet();
        PubsubFuture<Void> batchFuture = this.pubsub.acknowledge(this.project, this.subscription, batch);
        ((PubsubFuture)batchFuture.whenComplete((ignore, ex) -> {
            this.outstanding.decrementAndGet();
            if (ex != null) {
                futures.forEach(f -> f.completeExceptionally((Throwable)ex));
                this.backoff.sleep();
                return;
            }
            this.backoff.reset();
            for (int i = 0; i < futures.size(); ++i) {
                CompletableFuture future = (CompletableFuture)futures.get(i);
                future.complete(null);
            }
        })).whenComplete((v, t) -> this.send());
        return batch.size();
    }

    @Override
    public void close() throws IOException {
        this.scheduler.shutdownNow();
        try {
            this.scheduler.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.pubsub.close();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Pubsub pubsub;
        private String project;
        private String subscription;
        private int concurrency = 64;
        private int batchSize = 1000;
        private Integer queueSize;
        private long maxLatencyMs = 1000L;
        private int maxBackoffMultiplier = 0;

        public Builder pubsub(Pubsub pubsub) {
            this.pubsub = pubsub;
            return this;
        }

        public Builder project(String project) {
            this.project = project;
            return this;
        }

        public Builder subscription(String subscription) {
            this.subscription = subscription;
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder queueSize(Integer queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public Builder maxLatencyMs(long maxLatencyMs) {
            this.maxLatencyMs = maxLatencyMs;
            return this;
        }

        public Builder maxBackoffMultiplier(int maxBackoffMultiplier) {
            this.maxBackoffMultiplier = maxBackoffMultiplier;
            return this;
        }

        public Acker build() {
            return new Acker(this);
        }
    }

    private static class QueuedAck {
        private final String ackId;
        private final CompletableFuture<Void> future;

        public QueuedAck(String ackId, CompletableFuture<Void> future) {
            this.ackId = ackId;
            this.future = future;
        }
    }
}

