/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.spotify.google.cloud.pubsub.client.AcknowledgeRequest;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class AcknowledgeRequestBuilder {
    private List<String> ackIds;

    public AcknowledgeRequestBuilder() {
    }

    private AcknowledgeRequestBuilder(AcknowledgeRequest v) {
        List<String> _ackIds = v.ackIds();
        this.ackIds = _ackIds == null ? null : new ArrayList<String>(_ackIds);
    }

    private AcknowledgeRequestBuilder(AcknowledgeRequestBuilder v) {
        this.ackIds = v.ackIds == null ? null : new ArrayList<String>(v.ackIds);
    }

    public List<String> ackIds() {
        if (this.ackIds == null) {
            this.ackIds = new ArrayList<String>();
        }
        return this.ackIds;
    }

    public AcknowledgeRequestBuilder ackIds(List<? extends String> ackIds) {
        return this.ackIds((Collection<? extends String>)ackIds);
    }

    public AcknowledgeRequestBuilder ackIds(Collection<? extends String> ackIds) {
        if (ackIds == null) {
            throw new NullPointerException("ackIds");
        }
        for (String string : ackIds) {
            if (string != null) continue;
            throw new NullPointerException("ackIds: null item");
        }
        this.ackIds = new ArrayList<String>(ackIds);
        return this;
    }

    public AcknowledgeRequestBuilder ackIds(Iterable<? extends String> ackIds) {
        if (ackIds == null) {
            throw new NullPointerException("ackIds");
        }
        if (ackIds instanceof Collection) {
            return this.ackIds((Collection)ackIds);
        }
        return this.ackIds(ackIds.iterator());
    }

    public AcknowledgeRequestBuilder ackIds(Iterator<? extends String> ackIds) {
        if (ackIds == null) {
            throw new NullPointerException("ackIds");
        }
        this.ackIds = new ArrayList<String>();
        while (ackIds.hasNext()) {
            String item = ackIds.next();
            if (item == null) {
                throw new NullPointerException("ackIds: null item");
            }
            this.ackIds.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final AcknowledgeRequestBuilder ackIds(String ... ackIds) {
        if (ackIds == null) {
            throw new NullPointerException("ackIds");
        }
        return this.ackIds(Arrays.asList(ackIds));
    }

    public AcknowledgeRequestBuilder addAckId(String ackId) {
        if (ackId == null) {
            throw new NullPointerException("ackId");
        }
        if (this.ackIds == null) {
            this.ackIds = new ArrayList<String>();
        }
        this.ackIds.add(ackId);
        return this;
    }

    public AcknowledgeRequest build() {
        List _ackIds = this.ackIds != null ? Collections.unmodifiableList(new ArrayList<String>(this.ackIds)) : Collections.emptyList();
        return new Value(_ackIds);
    }

    public static AcknowledgeRequestBuilder from(AcknowledgeRequest v) {
        return new AcknowledgeRequestBuilder(v);
    }

    public static AcknowledgeRequestBuilder from(AcknowledgeRequestBuilder v) {
        return new AcknowledgeRequestBuilder(v);
    }

    private static final class Value
    implements AcknowledgeRequest {
        private final List<String> ackIds;

        private Value(@AutoMatter.Field(value="ackIds") List<String> ackIds) {
            this.ackIds = ackIds != null ? ackIds : Collections.emptyList();
        }

        @Override
        @AutoMatter.Field
        public List<String> ackIds() {
            return this.ackIds;
        }

        @Override
        public AcknowledgeRequestBuilder builder() {
            return new AcknowledgeRequestBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AcknowledgeRequest)) {
                return false;
            }
            AcknowledgeRequest that = (AcknowledgeRequest)o;
            return !(this.ackIds != null ? !this.ackIds.equals(that.ackIds()) : that.ackIds() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.ackIds != null ? this.ackIds.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "AcknowledgeRequest{ackIds=" + this.ackIds + '}';
        }
    }
}

