/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.google.api.client.util.Sleeper;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class Backoff {
    private Sleeper sleeper = Sleeper.DEFAULT;
    private Random random = new Random();
    private final long initialInterval;
    private final int maxBackoffMultiplier;
    private final AtomicInteger backoffMultiplier = new AtomicInteger(1);

    private Backoff(Builder builder) {
        this.initialInterval = builder.initialInterval;
        this.maxBackoffMultiplier = builder.maxBackoffMultiplier;
    }

    public void sleep() {
        if (this.maxBackoffMultiplier == 0) {
            return;
        }
        try {
            int backoff = this.backoffMultiplier.get();
            if (backoff < this.maxBackoffMultiplier) {
                this.backoffMultiplier.compareAndSet(backoff, backoff + 1);
            }
            this.sleeper.sleep((long)((double)(this.initialInterval * (long)backoff) * this.getRandomizationFactor()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void reset() {
        this.backoffMultiplier.set(1);
    }

    private double getRandomizationFactor() {
        return 0.9 + this.random.nextDouble() * 0.2;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long initialInterval = 0L;
        private int maxBackoffMultiplier = 0;

        public Builder initialInterval(long initialInterval) {
            this.initialInterval = initialInterval;
            return this;
        }

        public Builder maxBackoffMultiplier(int maxBackoffMultiplier) {
            this.maxBackoffMultiplier = maxBackoffMultiplier;
            return this;
        }

        public Backoff build() {
            return new Backoff(this);
        }
    }
}

