/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class ConfigurableSSLSocketFactory
extends SSLSocketFactory {
    private final String[] enabledCipherSuites;
    private final SSLSocketFactory sslSocketFactory;

    ConfigurableSSLSocketFactory(String[] enabledCipherSuites, SSLSocketFactory sslSocketFactory) {
        this.enabledCipherSuites = enabledCipherSuites;
        this.sslSocketFactory = sslSocketFactory;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Override
    public Socket createSocket(Socket sock, String host, int port, boolean autoClose) throws IOException {
        SSLSocket s = (SSLSocket)this.sslSocketFactory.createSocket(sock, host, port, autoClose);
        if (this.enabledCipherSuites != null) {
            s.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        return s;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocket s = (SSLSocket)this.sslSocketFactory.createSocket(host, port);
        if (this.enabledCipherSuites != null) {
            s.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        return s;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket s = (SSLSocket)this.sslSocketFactory.createSocket(host, port, localAddress, localPort);
        if (this.enabledCipherSuites != null) {
            s.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        return s;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket s = (SSLSocket)this.sslSocketFactory.createSocket(host, port);
        if (this.enabledCipherSuites != null) {
            s.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        return s;
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket s = (SSLSocket)this.sslSocketFactory.createSocket(host, port, localAddress, localPort);
        if (this.enabledCipherSuites != null) {
            s.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        return s;
    }
}

