/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.api.client.repackaged.com.google.common.base.Throwables;
import io.norberg.automatter.jackson.AutoMatterModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class Json {
    private static final ObjectMapper MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new AutoMatterModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new GuavaModule());

    Json() {
    }

    static <T> T read(byte[] src, Class<T> cls) throws IOException {
        return (T)MAPPER.readValue(src, cls);
    }

    static <T> T read(InputStream src, Class<T> cls) throws IOException {
        return (T)MAPPER.readValue(src, cls);
    }

    static byte[] write(Object value) {
        try {
            return MAPPER.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static void write(OutputStream stream, Object value) throws IOException {
        try {
            MAPPER.writeValue(stream, value);
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

