/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.google.common.base.CharMatcher;
import com.google.common.io.BaseEncoding;
import com.spotify.google.cloud.pubsub.client.MessageBuilder;
import io.norberg.automatter.AutoMatter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;

@AutoMatter
public interface Message {
    public static final CharMatcher BASE64_MATCHER = CharMatcher.anyOf((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=");

    public String data();

    public Map<String, String> attributes();

    public Optional<String> messageId();

    public Optional<Instant> publishTime();

    public static MessageBuilder builder() {
        return new MessageBuilder();
    }

    public static Message of(String data) {
        return Message.builder().data(data).build();
    }

    public static Message ofEncoded(CharSequence data) {
        return Message.of(Message.encode(data));
    }

    public static String encode(CharSequence data) {
        return Message.encode(CharBuffer.wrap(data));
    }

    public static String encode(CharSequence data, int start, int end) {
        return Message.encode(CharBuffer.wrap(data, start, end));
    }

    public static String encode(CharBuffer data) {
        return Message.encode(StandardCharsets.UTF_8.encode(data));
    }

    public static String encode(char[] data) {
        return Message.encode(StandardCharsets.UTF_8.encode(CharBuffer.wrap(data)));
    }

    public static String encode(ByteBuffer data) {
        if (data.hasArray()) {
            return Message.encode(data.array(), data.arrayOffset(), data.arrayOffset() + data.remaining());
        }
        byte[] bytes = new byte[data.remaining()];
        int mark = data.position();
        data.get(bytes);
        data.position(mark);
        return Message.encode(bytes);
    }

    public static String encode(byte[] data, int offset, int length) {
        if (offset == 0 && data.length == length) {
            return Message.encode(data);
        }
        return BaseEncoding.base64().encode(data, offset, length);
    }

    public static String encode(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    default public byte[] decodedData() {
        return Base64.getDecoder().decode(this.data());
    }

    default public CharSequence decodedDataUTF8() {
        return StandardCharsets.UTF_8.decode(ByteBuffer.wrap(this.decodedData()));
    }

    public static boolean isEncoded(Message message) {
        return BASE64_MATCHER.matchesAllOf((CharSequence)message.data());
    }
}

