/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.spotify.google.cloud.pubsub.client.Message;
import io.norberg.automatter.AutoMatter;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class MessageBuilder {
    private String data;
    private Map<String, String> attributes;
    private Optional<String> messageId;
    private Optional<Instant> publishTime;

    public MessageBuilder() {
        this.messageId = Optional.empty();
        this.publishTime = Optional.empty();
    }

    private MessageBuilder(Message v) {
        this.data = v.data();
        Map<String, String> _attributes = v.attributes();
        this.attributes = _attributes == null ? null : new HashMap<String, String>(_attributes);
        this.messageId = v.messageId();
        this.publishTime = v.publishTime();
    }

    private MessageBuilder(MessageBuilder v) {
        this.data = v.data;
        this.attributes = v.attributes == null ? null : new HashMap<String, String>(v.attributes);
        this.messageId = v.messageId;
        this.publishTime = v.publishTime;
    }

    public String data() {
        return this.data;
    }

    public MessageBuilder data(String data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.data = data;
        return this;
    }

    public Map<String, String> attributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    public MessageBuilder attributes(Map<? extends String, ? extends String> attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes");
        }
        for (Map.Entry<? extends String, ? extends String> entry : attributes.entrySet()) {
            if (entry.getKey() == null) {
                throw new NullPointerException("attributes: null key");
            }
            if (entry.getValue() != null) continue;
            throw new NullPointerException("attributes: null value");
        }
        this.attributes = new HashMap<String, String>(attributes);
        return this;
    }

    public MessageBuilder attributes(String k1, String v1) {
        if (k1 == null) {
            throw new NullPointerException("attributes: k1");
        }
        if (v1 == null) {
            throw new NullPointerException("attributes: v1");
        }
        this.attributes = new HashMap<String, String>();
        this.attributes.put(k1, v1);
        return this;
    }

    public MessageBuilder attributes(String k1, String v1, String k2, String v2) {
        this.attributes(k1, v1);
        if (k2 == null) {
            throw new NullPointerException("attributes: k2");
        }
        if (v2 == null) {
            throw new NullPointerException("attributes: v2");
        }
        this.attributes.put(k2, v2);
        return this;
    }

    public MessageBuilder attributes(String k1, String v1, String k2, String v2, String k3, String v3) {
        this.attributes(k1, v1, k2, v2);
        if (k3 == null) {
            throw new NullPointerException("attributes: k3");
        }
        if (v3 == null) {
            throw new NullPointerException("attributes: v3");
        }
        this.attributes.put(k3, v3);
        return this;
    }

    public MessageBuilder attributes(String k1, String v1, String k2, String v2, String k3, String v3, String k4, String v4) {
        this.attributes(k1, v1, k2, v2, k3, v3);
        if (k4 == null) {
            throw new NullPointerException("attributes: k4");
        }
        if (v4 == null) {
            throw new NullPointerException("attributes: v4");
        }
        this.attributes.put(k4, v4);
        return this;
    }

    public MessageBuilder attributes(String k1, String v1, String k2, String v2, String k3, String v3, String k4, String v4, String k5, String v5) {
        this.attributes(k1, v1, k2, v2, k3, v3, k4, v4);
        if (k5 == null) {
            throw new NullPointerException("attributes: k5");
        }
        if (v5 == null) {
            throw new NullPointerException("attributes: v5");
        }
        this.attributes.put(k5, v5);
        return this;
    }

    public MessageBuilder putAttribute(String key, String value) {
        if (key == null) {
            throw new NullPointerException("attribute: key");
        }
        if (value == null) {
            throw new NullPointerException("attribute: value");
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(key, value);
        return this;
    }

    public Optional<String> messageId() {
        return this.messageId;
    }

    public MessageBuilder messageId(String messageId) {
        return this.messageId(Optional.ofNullable(messageId));
    }

    public MessageBuilder messageId(Optional<? extends String> messageId) {
        if (messageId == null) {
            throw new NullPointerException("messageId");
        }
        this.messageId = messageId;
        return this;
    }

    public Optional<Instant> publishTime() {
        return this.publishTime;
    }

    public MessageBuilder publishTime(Instant publishTime) {
        return this.publishTime(Optional.ofNullable(publishTime));
    }

    public MessageBuilder publishTime(Optional<? extends Instant> publishTime) {
        if (publishTime == null) {
            throw new NullPointerException("publishTime");
        }
        this.publishTime = publishTime;
        return this;
    }

    public Message build() {
        Map _attributes = this.attributes != null ? Collections.unmodifiableMap(new HashMap<String, String>(this.attributes)) : Collections.emptyMap();
        return new Value(this.data, _attributes, this.messageId, this.publishTime);
    }

    public static MessageBuilder from(Message v) {
        return new MessageBuilder(v);
    }

    public static MessageBuilder from(MessageBuilder v) {
        return new MessageBuilder(v);
    }

    private static final class Value
    implements Message {
        private final String data;
        private final Map<String, String> attributes;
        private final Optional<String> messageId;
        private final Optional<Instant> publishTime;

        private Value(@AutoMatter.Field(value="data") String data, @AutoMatter.Field(value="attributes") Map<String, String> attributes, @AutoMatter.Field(value="messageId") Optional<String> messageId, @AutoMatter.Field(value="publishTime") Optional<Instant> publishTime) {
            if (data == null) {
                throw new NullPointerException("data");
            }
            if (messageId == null) {
                throw new NullPointerException("messageId");
            }
            if (publishTime == null) {
                throw new NullPointerException("publishTime");
            }
            this.data = data;
            this.attributes = attributes != null ? attributes : Collections.emptyMap();
            this.messageId = messageId;
            this.publishTime = publishTime;
        }

        @Override
        @AutoMatter.Field
        public String data() {
            return this.data;
        }

        @Override
        @AutoMatter.Field
        public Map<String, String> attributes() {
            return this.attributes;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> messageId() {
            return this.messageId;
        }

        @Override
        @AutoMatter.Field
        public Optional<Instant> publishTime() {
            return this.publishTime;
        }

        @Override
        public MessageBuilder builder() {
            return new MessageBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message that = (Message)o;
            if (this.data != null ? !this.data.equals(that.data()) : that.data() != null) {
                return false;
            }
            if (this.attributes != null ? !this.attributes.equals(that.attributes()) : that.attributes() != null) {
                return false;
            }
            if (this.messageId != null ? !this.messageId.equals(that.messageId()) : that.messageId() != null) {
                return false;
            }
            return !(this.publishTime != null ? !this.publishTime.equals(that.publishTime()) : that.publishTime() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
            result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
            result = 31 * result + (this.messageId != null ? this.messageId.hashCode() : 0);
            result = 31 * result + (this.publishTime != null ? this.publishTime.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Message{data=" + this.data + ", attributes=" + this.attributes + ", messageId=" + this.messageId + ", publishTime=" + this.publishTime + '}';
        }
    }
}

