/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.spotify.google.cloud.pubsub.client.ModifyAckDeadlineRequest;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class ModifyAckDeadlineRequestBuilder {
    private List<String> ackIds;
    private int ackDeadlineSeconds;

    public ModifyAckDeadlineRequestBuilder() {
    }

    private ModifyAckDeadlineRequestBuilder(ModifyAckDeadlineRequest v) {
        List<String> _ackIds = v.ackIds();
        this.ackIds = _ackIds == null ? null : new ArrayList<String>(_ackIds);
        this.ackDeadlineSeconds = v.ackDeadlineSeconds();
    }

    private ModifyAckDeadlineRequestBuilder(ModifyAckDeadlineRequestBuilder v) {
        this.ackIds = v.ackIds == null ? null : new ArrayList<String>(v.ackIds);
        this.ackDeadlineSeconds = v.ackDeadlineSeconds;
    }

    public List<String> ackIds() {
        if (this.ackIds == null) {
            this.ackIds = new ArrayList<String>();
        }
        return this.ackIds;
    }

    public ModifyAckDeadlineRequestBuilder ackIds(List<? extends String> ackIds) {
        return this.ackIds((Collection<? extends String>)ackIds);
    }

    public ModifyAckDeadlineRequestBuilder ackIds(Collection<? extends String> ackIds) {
        if (ackIds == null) {
            throw new NullPointerException("ackIds");
        }
        for (String string : ackIds) {
            if (string != null) continue;
            throw new NullPointerException("ackIds: null item");
        }
        this.ackIds = new ArrayList<String>(ackIds);
        return this;
    }

    public ModifyAckDeadlineRequestBuilder ackIds(Iterable<? extends String> ackIds) {
        if (ackIds == null) {
            throw new NullPointerException("ackIds");
        }
        if (ackIds instanceof Collection) {
            return this.ackIds((Collection)ackIds);
        }
        return this.ackIds(ackIds.iterator());
    }

    public ModifyAckDeadlineRequestBuilder ackIds(Iterator<? extends String> ackIds) {
        if (ackIds == null) {
            throw new NullPointerException("ackIds");
        }
        this.ackIds = new ArrayList<String>();
        while (ackIds.hasNext()) {
            String item = ackIds.next();
            if (item == null) {
                throw new NullPointerException("ackIds: null item");
            }
            this.ackIds.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final ModifyAckDeadlineRequestBuilder ackIds(String ... ackIds) {
        if (ackIds == null) {
            throw new NullPointerException("ackIds");
        }
        return this.ackIds(Arrays.asList(ackIds));
    }

    public ModifyAckDeadlineRequestBuilder addAckId(String ackId) {
        if (ackId == null) {
            throw new NullPointerException("ackId");
        }
        if (this.ackIds == null) {
            this.ackIds = new ArrayList<String>();
        }
        this.ackIds.add(ackId);
        return this;
    }

    public int ackDeadlineSeconds() {
        return this.ackDeadlineSeconds;
    }

    public ModifyAckDeadlineRequestBuilder ackDeadlineSeconds(int ackDeadlineSeconds) {
        this.ackDeadlineSeconds = ackDeadlineSeconds;
        return this;
    }

    public ModifyAckDeadlineRequest build() {
        List _ackIds = this.ackIds != null ? Collections.unmodifiableList(new ArrayList<String>(this.ackIds)) : Collections.emptyList();
        return new Value(_ackIds, this.ackDeadlineSeconds);
    }

    public static ModifyAckDeadlineRequestBuilder from(ModifyAckDeadlineRequest v) {
        return new ModifyAckDeadlineRequestBuilder(v);
    }

    public static ModifyAckDeadlineRequestBuilder from(ModifyAckDeadlineRequestBuilder v) {
        return new ModifyAckDeadlineRequestBuilder(v);
    }

    private static final class Value
    implements ModifyAckDeadlineRequest {
        private final List<String> ackIds;
        private final int ackDeadlineSeconds;

        private Value(@AutoMatter.Field(value="ackIds") List<String> ackIds, @AutoMatter.Field(value="ackDeadlineSeconds") int ackDeadlineSeconds) {
            this.ackIds = ackIds != null ? ackIds : Collections.emptyList();
            this.ackDeadlineSeconds = ackDeadlineSeconds;
        }

        @Override
        @AutoMatter.Field
        public List<String> ackIds() {
            return this.ackIds;
        }

        @Override
        @AutoMatter.Field
        public int ackDeadlineSeconds() {
            return this.ackDeadlineSeconds;
        }

        @Override
        public ModifyAckDeadlineRequestBuilder builder() {
            return new ModifyAckDeadlineRequestBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModifyAckDeadlineRequest)) {
                return false;
            }
            ModifyAckDeadlineRequest that = (ModifyAckDeadlineRequest)o;
            if (this.ackIds != null ? !this.ackIds.equals(that.ackIds()) : that.ackIds() != null) {
                return false;
            }
            return this.ackDeadlineSeconds == that.ackDeadlineSeconds();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.ackIds != null ? this.ackIds.hashCode() : 0);
            result = 31 * result + this.ackDeadlineSeconds;
            return result;
        }

        public String toString() {
            return "ModifyAckDeadlineRequest{ackIds=" + this.ackIds + ", ackDeadlineSeconds=" + this.ackDeadlineSeconds + '}';
        }
    }
}

