/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.spotify.google.cloud.pubsub.client.Message;
import com.spotify.google.cloud.pubsub.client.PublishRequest;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class PublishRequestBuilder {
    private List<Message> messages;

    public PublishRequestBuilder() {
    }

    private PublishRequestBuilder(PublishRequest v) {
        List<Message> _messages = v.messages();
        this.messages = _messages == null ? null : new ArrayList<Message>(_messages);
    }

    private PublishRequestBuilder(PublishRequestBuilder v) {
        this.messages = v.messages == null ? null : new ArrayList<Message>(v.messages);
    }

    public List<Message> messages() {
        if (this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        return this.messages;
    }

    public PublishRequestBuilder messages(List<? extends Message> messages) {
        return this.messages((Collection<? extends Message>)messages);
    }

    public PublishRequestBuilder messages(Collection<? extends Message> messages) {
        if (messages == null) {
            throw new NullPointerException("messages");
        }
        for (Message message : messages) {
            if (message != null) continue;
            throw new NullPointerException("messages: null item");
        }
        this.messages = new ArrayList<Message>(messages);
        return this;
    }

    public PublishRequestBuilder messages(Iterable<? extends Message> messages) {
        if (messages == null) {
            throw new NullPointerException("messages");
        }
        if (messages instanceof Collection) {
            return this.messages((Collection)messages);
        }
        return this.messages(messages.iterator());
    }

    public PublishRequestBuilder messages(Iterator<? extends Message> messages) {
        if (messages == null) {
            throw new NullPointerException("messages");
        }
        this.messages = new ArrayList<Message>();
        while (messages.hasNext()) {
            Message item = messages.next();
            if (item == null) {
                throw new NullPointerException("messages: null item");
            }
            this.messages.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final PublishRequestBuilder messages(Message ... messages) {
        if (messages == null) {
            throw new NullPointerException("messages");
        }
        return this.messages(Arrays.asList(messages));
    }

    public PublishRequestBuilder addMessage(Message message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        this.messages.add(message);
        return this;
    }

    public PublishRequest build() {
        List _messages = this.messages != null ? Collections.unmodifiableList(new ArrayList<Message>(this.messages)) : Collections.emptyList();
        return new Value(_messages);
    }

    public static PublishRequestBuilder from(PublishRequest v) {
        return new PublishRequestBuilder(v);
    }

    public static PublishRequestBuilder from(PublishRequestBuilder v) {
        return new PublishRequestBuilder(v);
    }

    private static final class Value
    implements PublishRequest {
        private final List<Message> messages;

        private Value(@AutoMatter.Field(value="messages") List<Message> messages) {
            this.messages = messages != null ? messages : Collections.emptyList();
        }

        @Override
        @AutoMatter.Field
        public List<Message> messages() {
            return this.messages;
        }

        @Override
        public PublishRequestBuilder builder() {
            return new PublishRequestBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PublishRequest)) {
                return false;
            }
            PublishRequest that = (PublishRequest)o;
            return !(this.messages != null ? !this.messages.equals(that.messages()) : that.messages() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.messages != null ? this.messages.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "PublishRequest{messages=" + this.messages + '}';
        }
    }
}

