/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.spotify.google.cloud.pubsub.client.PublishResponse;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class PublishResponseBuilder {
    private List<String> messageIds;

    public PublishResponseBuilder() {
    }

    private PublishResponseBuilder(PublishResponse v) {
        List<String> _messageIds = v.messageIds();
        this.messageIds = _messageIds == null ? null : new ArrayList<String>(_messageIds);
    }

    private PublishResponseBuilder(PublishResponseBuilder v) {
        this.messageIds = v.messageIds == null ? null : new ArrayList<String>(v.messageIds);
    }

    public List<String> messageIds() {
        if (this.messageIds == null) {
            this.messageIds = new ArrayList<String>();
        }
        return this.messageIds;
    }

    public PublishResponseBuilder messageIds(List<? extends String> messageIds) {
        return this.messageIds((Collection<? extends String>)messageIds);
    }

    public PublishResponseBuilder messageIds(Collection<? extends String> messageIds) {
        if (messageIds == null) {
            throw new NullPointerException("messageIds");
        }
        for (String string : messageIds) {
            if (string != null) continue;
            throw new NullPointerException("messageIds: null item");
        }
        this.messageIds = new ArrayList<String>(messageIds);
        return this;
    }

    public PublishResponseBuilder messageIds(Iterable<? extends String> messageIds) {
        if (messageIds == null) {
            throw new NullPointerException("messageIds");
        }
        if (messageIds instanceof Collection) {
            return this.messageIds((Collection)messageIds);
        }
        return this.messageIds(messageIds.iterator());
    }

    public PublishResponseBuilder messageIds(Iterator<? extends String> messageIds) {
        if (messageIds == null) {
            throw new NullPointerException("messageIds");
        }
        this.messageIds = new ArrayList<String>();
        while (messageIds.hasNext()) {
            String item = messageIds.next();
            if (item == null) {
                throw new NullPointerException("messageIds: null item");
            }
            this.messageIds.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final PublishResponseBuilder messageIds(String ... messageIds) {
        if (messageIds == null) {
            throw new NullPointerException("messageIds");
        }
        return this.messageIds(Arrays.asList(messageIds));
    }

    public PublishResponseBuilder addMessageId(String messageId) {
        if (messageId == null) {
            throw new NullPointerException("messageId");
        }
        if (this.messageIds == null) {
            this.messageIds = new ArrayList<String>();
        }
        this.messageIds.add(messageId);
        return this;
    }

    public PublishResponse build() {
        List _messageIds = this.messageIds != null ? Collections.unmodifiableList(new ArrayList<String>(this.messageIds)) : Collections.emptyList();
        return new Value(_messageIds);
    }

    public static PublishResponseBuilder from(PublishResponse v) {
        return new PublishResponseBuilder(v);
    }

    public static PublishResponseBuilder from(PublishResponseBuilder v) {
        return new PublishResponseBuilder(v);
    }

    private static final class Value
    implements PublishResponse {
        private final List<String> messageIds;

        private Value(@AutoMatter.Field(value="messageIds") List<String> messageIds) {
            this.messageIds = messageIds != null ? messageIds : Collections.emptyList();
        }

        @Override
        @AutoMatter.Field
        public List<String> messageIds() {
            return this.messageIds;
        }

        @Override
        public PublishResponseBuilder builder() {
            return new PublishResponseBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PublishResponse)) {
                return false;
            }
            PublishResponse that = (PublishResponse)o;
            return !(this.messageIds != null ? !this.messageIds.equals(that.messageIds()) : that.messageIds() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.messageIds != null ? this.messageIds.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "PublishResponse{messageIds=" + this.messageIds + '}';
        }
    }
}

