/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.util.Utils;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.repackaged.com.google.common.base.Throwables;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.MoreExecutors;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.spotify.google.cloud.pubsub.client.AcknowledgeRequest;
import com.spotify.google.cloud.pubsub.client.ConfigurableSSLSocketFactory;
import com.spotify.google.cloud.pubsub.client.Json;
import com.spotify.google.cloud.pubsub.client.Message;
import com.spotify.google.cloud.pubsub.client.ModifyAckDeadlineRequest;
import com.spotify.google.cloud.pubsub.client.PublishRequest;
import com.spotify.google.cloud.pubsub.client.PublishResponse;
import com.spotify.google.cloud.pubsub.client.PubsubFuture;
import com.spotify.google.cloud.pubsub.client.PullRequest;
import com.spotify.google.cloud.pubsub.client.PullResponse;
import com.spotify.google.cloud.pubsub.client.ReceivedMessage;
import com.spotify.google.cloud.pubsub.client.RequestFailedException;
import com.spotify.google.cloud.pubsub.client.RequestInfo;
import com.spotify.google.cloud.pubsub.client.Subscription;
import com.spotify.google.cloud.pubsub.client.SubscriptionCreateRequest;
import com.spotify.google.cloud.pubsub.client.SubscriptionList;
import com.spotify.google.cloud.pubsub.client.Topic;
import com.spotify.google.cloud.pubsub.client.TopicList;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pubsub
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Pubsub.class);
    private static final String VERSION = "1.0.0";
    private static final String USER_AGENT = "Spotify-Google-Pubsub-Java-Client/1.0.0 (gzip)";
    private static final Object NO_PAYLOAD = new Object();
    private static final String CLOUD_PLATFORM = "https://www.googleapis.com/auth/cloud-platform";
    private static final String PUBSUB = "https://www.googleapis.com/auth/pubsub";
    private static final List<String> SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/cloud-platform", (Object)"https://www.googleapis.com/auth/pubsub");
    private static final String APPLICATION_JSON_UTF8 = "application/json; charset=UTF-8";
    private static final int DEFAULT_PULL_MAX_MESSAGES = 1000;
    private static final boolean DEFAULT_PULL_RETURN_IMMEDIATELY = true;
    private final AsyncHttpClient client;
    private final String baseUri;
    private final Credential credential;
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private final ScheduledExecutorService scheduler = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1));
    private final ExecutorService executor = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newCachedThreadPool()));
    private volatile String accessToken;
    private final int compressionLevel;
    private NetHttpTransport transport;

    private Pubsub(Builder builder) {
        AsyncHttpClientConfig config = builder.clientConfig.build();
        log.debug("creating new pubsub client with config:");
        log.debug("uri: {}", (Object)builder.uri);
        log.debug("connect timeout: {}", (Object)config.getConnectTimeout());
        log.debug("read timeout: {}", (Object)config.getReadTimeout());
        log.debug("request timeout: {}", (Object)config.getRequestTimeout());
        log.debug("max connections: {}", (Object)config.getMaxConnections());
        log.debug("max connections per host: {}", (Object)config.getMaxConnectionsPerHost());
        log.debug("enabled cipher suites: {}", (Object)Arrays.toString(config.getEnabledCipherSuites()));
        log.debug("response compression enforced: {}", (Object)config.isCompressionEnforced());
        log.debug("request compression level: {}", (Object)builder.compressionLevel);
        log.debug("accept any certificate: {}", (Object)config.isAcceptAnyCertificate());
        log.debug("follows redirect: {}", (Object)config.isFollowRedirect());
        log.debug("pooled connection TTL: {}", (Object)config.getConnectionTTL());
        log.debug("pooled connection idle timeout: {}", (Object)config.getPooledConnectionIdleTimeout());
        log.debug("pooling connections: {}", (Object)config.isAllowPoolingConnections());
        log.debug("pooling SSL connections: {}", (Object)config.isAllowPoolingSslConnections());
        log.debug("user agent: {}", (Object)config.getUserAgent());
        log.debug("max request retry: {}", (Object)config.getMaxRequestRetry());
        ConfigurableSSLSocketFactory sslSocketFactory = new ConfigurableSSLSocketFactory(config.getEnabledCipherSuites(), (SSLSocketFactory)SSLSocketFactory.getDefault());
        this.transport = new NetHttpTransport.Builder().setSslSocketFactory((SSLSocketFactory)sslSocketFactory).build();
        this.client = new AsyncHttpClient(config);
        this.compressionLevel = builder.compressionLevel;
        this.credential = builder.credential == null ? this.scoped(Pubsub.defaultCredential()) : this.scoped(builder.credential);
        this.baseUri = builder.uri.toString();
        this.refreshAccessToken();
        if (this.accessToken == null) {
            throw new RuntimeException("Failed to get access token");
        }
        this.scheduler.scheduleAtFixedRate(this::refreshAccessToken, 10L, 10L, TimeUnit.SECONDS);
    }

    private Credential scoped(Credential credential) {
        if (credential instanceof GoogleCredential) {
            return this.scoped((GoogleCredential)credential);
        }
        return credential;
    }

    private Credential scoped(GoogleCredential credential) {
        if (credential.createScopedRequired()) {
            return credential.createScoped(SCOPES);
        }
        return credential;
    }

    private static Credential defaultCredential() {
        try {
            return GoogleCredential.getApplicationDefault((HttpTransport)Utils.getDefaultTransport(), (JsonFactory)Utils.getDefaultJsonFactory());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void close() {
        this.executor.shutdown();
        this.scheduler.shutdown();
        this.client.close();
        this.closeFuture.complete(null);
    }

    public CompletableFuture<Void> closeFuture() {
        return this.closeFuture;
    }

    private void refreshAccessToken() {
        Long expiresIn = this.credential.getExpiresInSeconds();
        String accessToken = this.credential.getAccessToken();
        if (accessToken == null || expiresIn != null && expiresIn <= 60L) {
            try {
                this.credential.refreshToken();
                accessToken = this.credential.getAccessToken();
            }
            catch (IOException e) {
                log.error("Failed to fetch access token", (Throwable)e);
            }
        }
        if (accessToken != null) {
            this.accessToken = accessToken;
        }
    }

    public PubsubFuture<TopicList> listTopics(String project) {
        String path = "projects/" + project + "/topics";
        return this.get("list topics", path, this.readJson(TopicList.class));
    }

    public PubsubFuture<TopicList> listTopics(String project, String pageToken) {
        String query = pageToken == null ? "" : "?pageToken=" + pageToken;
        String path = "projects/" + project + "/topics" + query;
        return this.get("list topics", path, this.readJson(TopicList.class));
    }

    public PubsubFuture<Topic> createTopic(String project, String topic) {
        return this.createTopic(Topic.canonicalTopic(project, topic));
    }

    private PubsubFuture<Topic> createTopic(String canonicalTopic) {
        Topic.validateCanonicalTopic(canonicalTopic);
        return this.put("create topic", canonicalTopic, NO_PAYLOAD, this.readJson(Topic.class));
    }

    public PubsubFuture<Topic> getTopic(String project, String topic) {
        return this.getTopic(Topic.canonicalTopic(project, topic));
    }

    public PubsubFuture<Topic> getTopic(String canonicalTopic) {
        Topic.validateCanonicalTopic(canonicalTopic);
        return this.get("get topic", canonicalTopic, this.readJson(Topic.class));
    }

    public PubsubFuture<Void> deleteTopic(String project, String topic) {
        return this.deleteTopic(Topic.canonicalTopic(project, topic));
    }

    public PubsubFuture<Void> deleteTopic(String canonicalTopic) {
        Topic.validateCanonicalTopic(canonicalTopic);
        return this.delete("delete topic", canonicalTopic, ResponseReader.VOID);
    }

    public PubsubFuture<Subscription> createSubscription(String project, String subscriptionName, String topic) {
        return this.createSubscription(Subscription.canonicalSubscription(project, subscriptionName), Topic.canonicalTopic(project, topic));
    }

    public PubsubFuture<SubscriptionList> listSubscriptions(String project) {
        String path = "projects/" + project + "/subscriptions";
        return this.get("list subscriptions", path, this.readJson(SubscriptionList.class));
    }

    public PubsubFuture<SubscriptionList> listSubscriptions(String project, String pageToken) {
        String query = pageToken == null ? "" : "?pageToken=" + pageToken;
        String path = "projects/" + project + "/subscriptions" + query;
        return this.get("list subscriptions", path, this.readJson(SubscriptionList.class));
    }

    public PubsubFuture<Subscription> createSubscription(String canonicalSubscriptionName, String canonicalTopic) {
        return this.createSubscription(Subscription.of(canonicalSubscriptionName, canonicalTopic));
    }

    private PubsubFuture<Subscription> createSubscription(Subscription subscription) {
        return this.createSubscription(subscription.name(), subscription);
    }

    private PubsubFuture<Subscription> createSubscription(String canonicalSubscriptionName, Subscription subscription) {
        Subscription.validateCanonicalSubscription(canonicalSubscriptionName);
        return this.put("create subscription", canonicalSubscriptionName, SubscriptionCreateRequest.of(subscription), this.readJson(Subscription.class));
    }

    public PubsubFuture<Subscription> getSubscription(String project, String subscription) {
        return this.getSubscription(Subscription.canonicalSubscription(project, subscription));
    }

    public PubsubFuture<Subscription> getSubscription(String canonicalSubscriptionName) {
        Subscription.validateCanonicalSubscription(canonicalSubscriptionName);
        return this.get("get subscription", canonicalSubscriptionName, this.readJson(Subscription.class));
    }

    public PubsubFuture<Void> deleteSubscription(String project, String subscription) {
        return this.deleteSubscription(Subscription.canonicalSubscription(project, subscription));
    }

    public PubsubFuture<Void> deleteSubscription(String canonicalSubscriptionName) {
        Subscription.validateCanonicalSubscription(canonicalSubscriptionName);
        return this.delete("delete subscription", canonicalSubscriptionName, ResponseReader.VOID);
    }

    public PubsubFuture<List<String>> publish(String project, String topic, Message ... messages) {
        return this.publish(project, topic, Arrays.asList(messages));
    }

    public PubsubFuture<List<String>> publish(String project, String topic, List<Message> messages) {
        return this.publish0(messages, Topic.canonicalTopic(project, topic));
    }

    public PubsubFuture<List<String>> publish(List<Message> messages, String canonicalTopic) {
        Topic.validateCanonicalTopic(canonicalTopic);
        return this.publish0(messages, canonicalTopic);
    }

    private PubsubFuture<List<String>> publish0(List<Message> messages, String canonicalTopic) {
        String path = canonicalTopic + ":publish";
        for (Message message : messages) {
            if (Message.isEncoded(message)) continue;
            throw new IllegalArgumentException("Message data must be Base64 encoded: " + message);
        }
        return this.post("publish", path, PublishRequest.of(messages), this.readJson(PublishResponse.class).andThen(PublishResponse::messageIds));
    }

    public PubsubFuture<List<ReceivedMessage>> pull(String project, String subscription) {
        return this.pull(project, subscription, true, 1000);
    }

    public PubsubFuture<List<ReceivedMessage>> pull(String project, String subscription, boolean returnImmediately) {
        return this.pull(project, subscription, returnImmediately, 1000);
    }

    public PubsubFuture<List<ReceivedMessage>> pull(String project, String subscription, boolean returnImmediately, int maxMessages) {
        return this.pull(Subscription.canonicalSubscription(project, subscription), returnImmediately, maxMessages);
    }

    public PubsubFuture<List<ReceivedMessage>> pull(String canonicalSubscriptionName) {
        return this.pull(canonicalSubscriptionName, true);
    }

    public PubsubFuture<List<ReceivedMessage>> pull(String canonicalSubscriptionName, boolean returnImmediately) {
        return this.pull(canonicalSubscriptionName, returnImmediately, 1000);
    }

    public PubsubFuture<List<ReceivedMessage>> pull(String canonicalSubscriptionName, boolean returnImmediately, int maxMessages) {
        String path = canonicalSubscriptionName + ":pull";
        PullRequest req = PullRequest.builder().returnImmediately(returnImmediately).maxMessages(maxMessages).build();
        return this.pull(path, req);
    }

    public PubsubFuture<List<ReceivedMessage>> pull(String path, PullRequest pullRequest) {
        return this.requestJavaNet("pull", HttpMethod.POST, path, pullRequest, this.readJson(PullResponse.class).andThen(PullResponse::receivedMessages));
    }

    public PubsubFuture<Void> acknowledge(String project, String subscription, String ... ackIds) {
        return this.acknowledge(project, subscription, Arrays.asList(ackIds));
    }

    public PubsubFuture<Void> acknowledge(String project, String subscription, List<String> ackIds) {
        return this.acknowledge(Subscription.canonicalSubscription(project, subscription), ackIds);
    }

    public PubsubFuture<Void> acknowledge(String canonicalSubscriptionName, List<String> ackIds) {
        String path = canonicalSubscriptionName + ":acknowledge";
        AcknowledgeRequest req = AcknowledgeRequest.builder().ackIds(ackIds).build();
        return this.post("acknowledge", path, req, ResponseReader.VOID);
    }

    public PubsubFuture<Void> modifyAckDeadline(String project, String subscription, int ackDeadlineSeconds, String ... ackIds) {
        return this.modifyAckDeadline(project, subscription, ackDeadlineSeconds, Arrays.asList(ackIds));
    }

    public PubsubFuture<Void> modifyAckDeadline(String project, String subscription, int ackDeadlineSeconds, List<String> ackIds) {
        return this.modifyAckDeadline(Subscription.canonicalSubscription(project, subscription), ackDeadlineSeconds, ackIds);
    }

    public PubsubFuture<Void> modifyAckDeadline(String canonicalSubscriptionName, int ackDeadlineSeconds, List<String> ackIds) {
        String path = canonicalSubscriptionName + ":modifyAckDeadline";
        ModifyAckDeadlineRequest req = ModifyAckDeadlineRequest.builder().ackDeadlineSeconds(ackDeadlineSeconds).ackIds(ackIds).build();
        return this.post("modify ack deadline", path, req, ResponseReader.VOID);
    }

    private <T> PubsubFuture<T> get(String operation, String path, ResponseReader<T> responseReader) {
        return this.request(operation, HttpMethod.GET, path, responseReader);
    }

    private <T> PubsubFuture<T> post(String operation, String path, Object payload, ResponseReader<T> responseReader) {
        return this.request(operation, HttpMethod.POST, path, payload, responseReader);
    }

    private <T> PubsubFuture<T> put(String operation, String path, Object payload, ResponseReader<T> responseReader) {
        return this.request(operation, HttpMethod.PUT, path, payload, responseReader);
    }

    private <T> PubsubFuture<T> delete(String operation, String path, ResponseReader<T> responseReader) {
        return this.request(operation, HttpMethod.DELETE, path, responseReader);
    }

    private <T> PubsubFuture<T> request(String operation, HttpMethod method, String path, ResponseReader<T> responseReader) {
        return this.request(operation, method, path, NO_PAYLOAD, responseReader);
    }

    private <T> PubsubFuture<T> request(String operation, final HttpMethod method, String path, Object payload, final ResponseReader<T> responseReader) {
        long payloadSize;
        String uri = this.baseUri + path;
        RequestBuilder builder = new RequestBuilder().setUrl(uri).setMethod(method.toString()).setHeader("Authorization", "Bearer " + this.accessToken).setHeader("User-Agent", USER_AGENT);
        if (payload != NO_PAYLOAD) {
            byte[] json = this.gzipJson(payload);
            payloadSize = json.length;
            builder.setHeader("Content-Encoding", "gzip");
            builder.setHeader("Content-Length", String.valueOf(json.length));
            builder.setHeader("Content-Type", APPLICATION_JSON_UTF8);
            builder.setBody(json);
        } else {
            builder.setHeader("Content-Length", String.valueOf(0));
            payloadSize = 0L;
        }
        Request request = builder.build();
        RequestInfo requestInfo = RequestInfo.builder().operation(operation).method(method.toString()).uri(uri).payloadSize(payloadSize).build();
        final PubsubFuture future = new PubsubFuture(requestInfo);
        this.client.executeRequest(request, (AsyncHandler)new AsyncHandler<Void>(){
            private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();

            public void onThrowable(Throwable t) {
                future.fail(t);
            }

            public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                this.bytes.write(bodyPart.getBodyPartBytes());
                return AsyncHandler.STATE.CONTINUE;
            }

            public AsyncHandler.STATE onStatusReceived(HttpResponseStatus status) throws Exception {
                if (status.getStatusCode() == 404 && method == HttpMethod.GET || method == HttpMethod.DELETE) {
                    future.succeed(null);
                    return AsyncHandler.STATE.ABORT;
                }
                int statusCode = status.getStatusCode();
                if (statusCode < 200 || statusCode >= 300) {
                    future.fail(new RequestFailedException(status.getStatusCode(), status.getStatusText()));
                    return AsyncHandler.STATE.ABORT;
                }
                if (responseReader == ResponseReader.VOID) {
                    future.succeed(null);
                    return AsyncHandler.STATE.ABORT;
                }
                return AsyncHandler.STATE.CONTINUE;
            }

            public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
                return AsyncHandler.STATE.CONTINUE;
            }

            public Void onCompleted() throws Exception {
                if (future.isDone()) {
                    return null;
                }
                try {
                    future.succeed(responseReader.read(this.bytes.toByteArray()));
                }
                catch (Exception e) {
                    future.fail(e);
                }
                return null;
            }
        });
        return future;
    }

    private <T> PubsubFuture<T> requestJavaNet(String operation, HttpMethod method, String path, Object payload, ResponseReader<T> responseReader) {
        long payloadSize;
        HttpRequest request;
        HttpRequestFactory requestFactory = this.transport.createRequestFactory();
        String uri = this.baseUri + path;
        HttpHeaders headers = new HttpHeaders();
        try {
            request = requestFactory.buildRequest(method.getName(), new GenericUrl(URI.create(uri)), null);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        headers.setAuthorization("Bearer " + this.accessToken);
        headers.setUserAgent("Spotify");
        if (payload != NO_PAYLOAD) {
            byte[] json = this.gzipJson(payload);
            payloadSize = json.length;
            headers.setContentEncoding("gzip");
            headers.setContentLength(Long.valueOf(json.length));
            headers.setContentType(APPLICATION_JSON_UTF8);
            request.setContent((HttpContent)new ByteArrayContent(APPLICATION_JSON_UTF8, json));
        } else {
            payloadSize = 0L;
        }
        request.setHeaders(headers);
        RequestInfo requestInfo = RequestInfo.builder().operation(operation).method(method.toString()).uri(uri).payloadSize(payloadSize).build();
        PubsubFuture future = new PubsubFuture(requestInfo);
        this.executor.execute(() -> {
            HttpResponse response;
            try {
                response = request.execute();
            }
            catch (IOException e) {
                future.fail(e);
                return;
            }
            if (response.getStatusCode() == 404 && method == HttpMethod.GET || method == HttpMethod.DELETE) {
                future.succeed(null);
                return;
            }
            int statusCode = response.getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                future.fail(new RequestFailedException(response.getStatusCode(), response.getStatusMessage()));
                return;
            }
            if (responseReader == ResponseReader.VOID) {
                future.succeed(null);
                return;
            }
            try {
                future.succeed(responseReader.read(ByteStreams.toByteArray((InputStream)response.getContent())));
            }
            catch (Exception e) {
                future.fail(e);
            }
        });
        return future;
    }

    /*
     * Exception decompiling
     */
    private byte[] gzipJson(Object payload) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Pubsub create() {
        return Pubsub.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private <T> ResponseReader<T> readJson(Class<T> cls) {
        return payload -> Json.read(payload, cls);
    }

    @FunctionalInterface
    static interface ResponseReader<T> {
        public static final ResponseReader<Void> VOID = bytes -> null;

        public T read(byte[] var1) throws Exception;

        default public <U> ResponseReader<U> andThen(Function<T, U> f) {
            return bytes -> f.apply(this.read(bytes));
        }
    }

    public static class Builder {
        private static final URI DEFAULT_URI = URI.create("https://pubsub.googleapis.com/v1/");
        private static final int DEFAULT_REQUEST_TIMEOUT_MS = 30000;
        private final AsyncHttpClientConfig.Builder clientConfig = new AsyncHttpClientConfig.Builder().setCompressionEnforced(true).setUseProxySelector(true).setRequestTimeout(30000).setReadTimeout(30000);
        private Credential credential;
        private URI uri = DEFAULT_URI;
        private int compressionLevel = -1;

        private Builder() {
        }

        public Pubsub build() {
            return new Pubsub(this);
        }

        public Builder connectTimeout(int connectTimeout) {
            this.clientConfig.setConnectTimeout(connectTimeout);
            return this;
        }

        public Builder compressionLevel(int compressionLevel) {
            Preconditions.checkArgument((compressionLevel > -1 && compressionLevel <= 9 ? 1 : 0) != 0, (Object)"compressionLevel must be -1 or 0-9.");
            this.compressionLevel = compressionLevel;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.clientConfig.setReadTimeout(readTimeout);
            return this;
        }

        public Builder requestTimeout(int requestTimeout) {
            this.clientConfig.setRequestTimeout(requestTimeout);
            return this;
        }

        public Builder maxConnections(int maxConnections) {
            this.clientConfig.setMaxConnections(maxConnections);
            return this;
        }

        public Builder pooledConnectionTTL(int pooledConnectionTTL) {
            this.clientConfig.setConnectionTTL(pooledConnectionTTL);
            return this;
        }

        public Builder pooledConnectionIdleTimeout(int pooledConnectionIdleTimeout) {
            this.clientConfig.setPooledConnectionIdleTimeout(pooledConnectionIdleTimeout);
            return this;
        }

        public Builder allowPoolingConnections(boolean allowPoolingConnections) {
            this.clientConfig.setAllowPoolingConnections(allowPoolingConnections);
            this.clientConfig.setAllowPoolingSslConnections(allowPoolingConnections);
            return this;
        }

        public Builder credential(Credential credential) {
            this.credential = credential;
            return this;
        }

        public Builder enabledCipherSuites(String ... enabledCipherSuites) {
            this.clientConfig.setEnabledCipherSuites(enabledCipherSuites);
            return this;
        }

        public Builder enabledCipherSuites(List<String> enabledCipherSuites) {
            this.clientConfig.setEnabledCipherSuites(enabledCipherSuites.toArray(new String[enabledCipherSuites.size()]));
            return this;
        }

        public Builder uri(URI uri) {
            Preconditions.checkNotNull((Object)uri, (Object)"uri");
            Preconditions.checkArgument((uri.getRawQuery() == null ? 1 : 0) != 0, (String)"illegal service uri: %s", (Object[])new Object[]{uri});
            Preconditions.checkArgument((uri.getRawFragment() == null ? 1 : 0) != 0, (String)"illegal service uri: %s", (Object[])new Object[]{uri});
            this.uri = uri;
            return this;
        }
    }
}

