/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.spotify.google.cloud.pubsub.client.PullRequest;
import io.norberg.automatter.AutoMatter;

final class PullRequestBuilder {
    private boolean returnImmediately;
    private int maxMessages;

    public PullRequestBuilder() {
    }

    private PullRequestBuilder(PullRequest v) {
        this.returnImmediately = v.returnImmediately();
        this.maxMessages = v.maxMessages();
    }

    private PullRequestBuilder(PullRequestBuilder v) {
        this.returnImmediately = v.returnImmediately;
        this.maxMessages = v.maxMessages;
    }

    public boolean returnImmediately() {
        return this.returnImmediately;
    }

    public PullRequestBuilder returnImmediately(boolean returnImmediately) {
        this.returnImmediately = returnImmediately;
        return this;
    }

    public int maxMessages() {
        return this.maxMessages;
    }

    public PullRequestBuilder maxMessages(int maxMessages) {
        this.maxMessages = maxMessages;
        return this;
    }

    public PullRequest build() {
        return new Value(this.returnImmediately, this.maxMessages);
    }

    public static PullRequestBuilder from(PullRequest v) {
        return new PullRequestBuilder(v);
    }

    public static PullRequestBuilder from(PullRequestBuilder v) {
        return new PullRequestBuilder(v);
    }

    private static final class Value
    implements PullRequest {
        private final boolean returnImmediately;
        private final int maxMessages;

        private Value(@AutoMatter.Field(value="returnImmediately") boolean returnImmediately, @AutoMatter.Field(value="maxMessages") int maxMessages) {
            this.returnImmediately = returnImmediately;
            this.maxMessages = maxMessages;
        }

        @Override
        @AutoMatter.Field
        public boolean returnImmediately() {
            return this.returnImmediately;
        }

        @Override
        @AutoMatter.Field
        public int maxMessages() {
            return this.maxMessages;
        }

        @Override
        public PullRequestBuilder builder() {
            return new PullRequestBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PullRequest)) {
                return false;
            }
            PullRequest that = (PullRequest)o;
            if (this.returnImmediately != that.returnImmediately()) {
                return false;
            }
            return this.maxMessages == that.maxMessages();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.returnImmediately ? 1231 : 1237);
            result = 31 * result + this.maxMessages;
            return result;
        }

        public String toString() {
            return "PullRequest{returnImmediately=" + this.returnImmediately + ", maxMessages=" + this.maxMessages + '}';
        }
    }
}

