/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.spotify.google.cloud.pubsub.client.PullResponse;
import com.spotify.google.cloud.pubsub.client.ReceivedMessage;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class PullResponseBuilder {
    private List<ReceivedMessage> receivedMessages;

    public PullResponseBuilder() {
    }

    private PullResponseBuilder(PullResponse v) {
        List<ReceivedMessage> _receivedMessages = v.receivedMessages();
        this.receivedMessages = _receivedMessages == null ? null : new ArrayList<ReceivedMessage>(_receivedMessages);
    }

    private PullResponseBuilder(PullResponseBuilder v) {
        this.receivedMessages = v.receivedMessages == null ? null : new ArrayList<ReceivedMessage>(v.receivedMessages);
    }

    public List<ReceivedMessage> receivedMessages() {
        if (this.receivedMessages == null) {
            this.receivedMessages = new ArrayList<ReceivedMessage>();
        }
        return this.receivedMessages;
    }

    public PullResponseBuilder receivedMessages(List<? extends ReceivedMessage> receivedMessages) {
        return this.receivedMessages((Collection<? extends ReceivedMessage>)receivedMessages);
    }

    public PullResponseBuilder receivedMessages(Collection<? extends ReceivedMessage> receivedMessages) {
        if (receivedMessages == null) {
            throw new NullPointerException("receivedMessages");
        }
        for (ReceivedMessage receivedMessage : receivedMessages) {
            if (receivedMessage != null) continue;
            throw new NullPointerException("receivedMessages: null item");
        }
        this.receivedMessages = new ArrayList<ReceivedMessage>(receivedMessages);
        return this;
    }

    public PullResponseBuilder receivedMessages(Iterable<? extends ReceivedMessage> receivedMessages) {
        if (receivedMessages == null) {
            throw new NullPointerException("receivedMessages");
        }
        if (receivedMessages instanceof Collection) {
            return this.receivedMessages((Collection)receivedMessages);
        }
        return this.receivedMessages(receivedMessages.iterator());
    }

    public PullResponseBuilder receivedMessages(Iterator<? extends ReceivedMessage> receivedMessages) {
        if (receivedMessages == null) {
            throw new NullPointerException("receivedMessages");
        }
        this.receivedMessages = new ArrayList<ReceivedMessage>();
        while (receivedMessages.hasNext()) {
            ReceivedMessage item = receivedMessages.next();
            if (item == null) {
                throw new NullPointerException("receivedMessages: null item");
            }
            this.receivedMessages.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final PullResponseBuilder receivedMessages(ReceivedMessage ... receivedMessages) {
        if (receivedMessages == null) {
            throw new NullPointerException("receivedMessages");
        }
        return this.receivedMessages(Arrays.asList(receivedMessages));
    }

    public PullResponseBuilder addReceivedMessage(ReceivedMessage receivedMessage) {
        if (receivedMessage == null) {
            throw new NullPointerException("receivedMessage");
        }
        if (this.receivedMessages == null) {
            this.receivedMessages = new ArrayList<ReceivedMessage>();
        }
        this.receivedMessages.add(receivedMessage);
        return this;
    }

    public PullResponse build() {
        List _receivedMessages = this.receivedMessages != null ? Collections.unmodifiableList(new ArrayList<ReceivedMessage>(this.receivedMessages)) : Collections.emptyList();
        return new Value(_receivedMessages);
    }

    public static PullResponseBuilder from(PullResponse v) {
        return new PullResponseBuilder(v);
    }

    public static PullResponseBuilder from(PullResponseBuilder v) {
        return new PullResponseBuilder(v);
    }

    private static final class Value
    implements PullResponse {
        private final List<ReceivedMessage> receivedMessages;

        private Value(@AutoMatter.Field(value="receivedMessages") List<ReceivedMessage> receivedMessages) {
            this.receivedMessages = receivedMessages != null ? receivedMessages : Collections.emptyList();
        }

        @Override
        @AutoMatter.Field
        public List<ReceivedMessage> receivedMessages() {
            return this.receivedMessages;
        }

        @Override
        public PullResponseBuilder builder() {
            return new PullResponseBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PullResponse)) {
                return false;
            }
            PullResponse that = (PullResponse)o;
            return !(this.receivedMessages != null ? !this.receivedMessages.equals(that.receivedMessages()) : that.receivedMessages() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.receivedMessages != null ? this.receivedMessages.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "PullResponse{receivedMessages=" + this.receivedMessages + '}';
        }
    }
}

