/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.spotify.google.cloud.pubsub.client.PushConfig;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;

public final class PushConfigBuilder {
    private Optional<String> pushEndpoint;

    public PushConfigBuilder() {
        this.pushEndpoint = Optional.empty();
    }

    private PushConfigBuilder(PushConfig v) {
        this.pushEndpoint = v.pushEndpoint();
    }

    private PushConfigBuilder(PushConfigBuilder v) {
        this.pushEndpoint = v.pushEndpoint;
    }

    public Optional<String> pushEndpoint() {
        return this.pushEndpoint;
    }

    public PushConfigBuilder pushEndpoint(String pushEndpoint) {
        return this.pushEndpoint(Optional.ofNullable(pushEndpoint));
    }

    public PushConfigBuilder pushEndpoint(Optional<? extends String> pushEndpoint) {
        if (pushEndpoint == null) {
            throw new NullPointerException("pushEndpoint");
        }
        this.pushEndpoint = pushEndpoint;
        return this;
    }

    public PushConfig build() {
        return new Value(this.pushEndpoint);
    }

    public static PushConfigBuilder from(PushConfig v) {
        return new PushConfigBuilder(v);
    }

    public static PushConfigBuilder from(PushConfigBuilder v) {
        return new PushConfigBuilder(v);
    }

    private static final class Value
    implements PushConfig {
        private final Optional<String> pushEndpoint;

        private Value(@AutoMatter.Field(value="pushEndpoint") Optional<String> pushEndpoint) {
            if (pushEndpoint == null) {
                throw new NullPointerException("pushEndpoint");
            }
            this.pushEndpoint = pushEndpoint;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> pushEndpoint() {
            return this.pushEndpoint;
        }

        @Override
        public PushConfigBuilder builder() {
            return new PushConfigBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PushConfig)) {
                return false;
            }
            PushConfig that = (PushConfig)o;
            return !(this.pushEndpoint != null ? !this.pushEndpoint.equals(that.pushEndpoint()) : that.pushEndpoint() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.pushEndpoint != null ? this.pushEndpoint.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "PushConfig{pushEndpoint=" + this.pushEndpoint + '}';
        }
    }
}

