/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.spotify.google.cloud.pubsub.client.Message;
import com.spotify.google.cloud.pubsub.client.ReceivedMessage;
import io.norberg.automatter.AutoMatter;

public final class ReceivedMessageBuilder {
    private String ackId;
    private Message message;

    public ReceivedMessageBuilder() {
    }

    private ReceivedMessageBuilder(ReceivedMessage v) {
        this.ackId = v.ackId();
        this.message = v.message();
    }

    private ReceivedMessageBuilder(ReceivedMessageBuilder v) {
        this.ackId = v.ackId;
        this.message = v.message;
    }

    public String ackId() {
        return this.ackId;
    }

    public ReceivedMessageBuilder ackId(String ackId) {
        if (ackId == null) {
            throw new NullPointerException("ackId");
        }
        this.ackId = ackId;
        return this;
    }

    public Message message() {
        return this.message;
    }

    public ReceivedMessageBuilder message(Message message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.message = message;
        return this;
    }

    public ReceivedMessage build() {
        return new Value(this.ackId, this.message);
    }

    public static ReceivedMessageBuilder from(ReceivedMessage v) {
        return new ReceivedMessageBuilder(v);
    }

    public static ReceivedMessageBuilder from(ReceivedMessageBuilder v) {
        return new ReceivedMessageBuilder(v);
    }

    private static final class Value
    implements ReceivedMessage {
        private final String ackId;
        private final Message message;

        private Value(@AutoMatter.Field(value="ackId") String ackId, @AutoMatter.Field(value="message") Message message) {
            if (ackId == null) {
                throw new NullPointerException("ackId");
            }
            if (message == null) {
                throw new NullPointerException("message");
            }
            this.ackId = ackId;
            this.message = message;
        }

        @Override
        @AutoMatter.Field
        public String ackId() {
            return this.ackId;
        }

        @Override
        @AutoMatter.Field
        public Message message() {
            return this.message;
        }

        @Override
        public ReceivedMessageBuilder builder() {
            return new ReceivedMessageBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ReceivedMessage)) {
                return false;
            }
            ReceivedMessage that = (ReceivedMessage)o;
            if (this.ackId != null ? !this.ackId.equals(that.ackId()) : that.ackId() != null) {
                return false;
            }
            return !(this.message != null ? !this.message.equals(that.message()) : that.message() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.ackId != null ? this.ackId.hashCode() : 0);
            result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ReceivedMessage{ackId=" + this.ackId + ", message=" + this.message + '}';
        }
    }
}

