/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.spotify.google.cloud.pubsub.client.RequestInfo;
import io.norberg.automatter.AutoMatter;

public final class RequestInfoBuilder {
    private String operation;
    private String method;
    private String uri;
    private long payloadSize;

    public RequestInfoBuilder() {
    }

    private RequestInfoBuilder(RequestInfo v) {
        this.operation = v.operation();
        this.method = v.method();
        this.uri = v.uri();
        this.payloadSize = v.payloadSize();
    }

    private RequestInfoBuilder(RequestInfoBuilder v) {
        this.operation = v.operation;
        this.method = v.method;
        this.uri = v.uri;
        this.payloadSize = v.payloadSize;
    }

    public String operation() {
        return this.operation;
    }

    public RequestInfoBuilder operation(String operation) {
        if (operation == null) {
            throw new NullPointerException("operation");
        }
        this.operation = operation;
        return this;
    }

    public String method() {
        return this.method;
    }

    public RequestInfoBuilder method(String method) {
        if (method == null) {
            throw new NullPointerException("method");
        }
        this.method = method;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public RequestInfoBuilder uri(String uri) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        this.uri = uri;
        return this;
    }

    public long payloadSize() {
        return this.payloadSize;
    }

    public RequestInfoBuilder payloadSize(long payloadSize) {
        this.payloadSize = payloadSize;
        return this;
    }

    public RequestInfo build() {
        return new Value(this.operation, this.method, this.uri, this.payloadSize);
    }

    public static RequestInfoBuilder from(RequestInfo v) {
        return new RequestInfoBuilder(v);
    }

    public static RequestInfoBuilder from(RequestInfoBuilder v) {
        return new RequestInfoBuilder(v);
    }

    private static final class Value
    implements RequestInfo {
        private final String operation;
        private final String method;
        private final String uri;
        private final long payloadSize;

        private Value(@AutoMatter.Field(value="operation") String operation, @AutoMatter.Field(value="method") String method, @AutoMatter.Field(value="uri") String uri, @AutoMatter.Field(value="payloadSize") long payloadSize) {
            if (operation == null) {
                throw new NullPointerException("operation");
            }
            if (method == null) {
                throw new NullPointerException("method");
            }
            if (uri == null) {
                throw new NullPointerException("uri");
            }
            this.operation = operation;
            this.method = method;
            this.uri = uri;
            this.payloadSize = payloadSize;
        }

        @Override
        @AutoMatter.Field
        public String operation() {
            return this.operation;
        }

        @Override
        @AutoMatter.Field
        public String method() {
            return this.method;
        }

        @Override
        @AutoMatter.Field
        public String uri() {
            return this.uri;
        }

        @Override
        @AutoMatter.Field
        public long payloadSize() {
            return this.payloadSize;
        }

        @Override
        public RequestInfoBuilder builder() {
            return new RequestInfoBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RequestInfo)) {
                return false;
            }
            RequestInfo that = (RequestInfo)o;
            if (this.operation != null ? !this.operation.equals(that.operation()) : that.operation() != null) {
                return false;
            }
            if (this.method != null ? !this.method.equals(that.method()) : that.method() != null) {
                return false;
            }
            if (this.uri != null ? !this.uri.equals(that.uri()) : that.uri() != null) {
                return false;
            }
            return this.payloadSize == that.payloadSize();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.operation != null ? this.operation.hashCode() : 0);
            result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
            result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
            result = 31 * result + (int)(this.payloadSize ^ this.payloadSize >>> 32);
            return result;
        }

        public String toString() {
            return "RequestInfo{operation=" + this.operation + ", method=" + this.method + ", uri=" + this.uri + ", payloadSize=" + this.payloadSize + '}';
        }
    }
}

