/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.spotify.google.cloud.pubsub.client.PushConfig;
import com.spotify.google.cloud.pubsub.client.SubscriptionBuilder;
import com.spotify.google.cloud.pubsub.client.Topic;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;
import java.util.regex.Pattern;

@AutoMatter
public interface Subscription {
    public static final Pattern PATTERN = Pattern.compile("^projects/[^/]*/subscriptions/[^/]*$");
    public static final String PROJECTS = "projects";
    public static final String SUBSCRIPTIONS = "subscriptions";

    public String name();

    public String topic();

    public Optional<PushConfig> pushConfig();

    public Optional<Integer> ackDeadlineSeconds();

    public static SubscriptionBuilder builder() {
        return new SubscriptionBuilder();
    }

    public static Subscription of(String project, String name, String topic) {
        return Subscription.of(Subscription.canonicalSubscription(project, name), Topic.canonicalTopic(project, topic));
    }

    public static Subscription of(String canonicalSubscription, String canonicalTopic) {
        Subscription.validateCanonicalSubscription(canonicalSubscription);
        Topic.validateCanonicalTopic(canonicalTopic);
        return Subscription.builder().name(canonicalSubscription).topic(canonicalTopic).build();
    }

    public static String canonicalSubscription(String project, String subscription) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)project) && !project.contains("/") ? 1 : 0) != 0, (String)"illegal project: %s", (Object[])new Object[]{project});
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)subscription) && !subscription.contains("/") && !subscription.startsWith("goog") ? 1 : 0) != 0, (String)"illegal subscription: %s", (Object[])new Object[]{subscription});
        return "projects/" + project + '/' + SUBSCRIPTIONS + '/' + subscription;
    }

    public static void validateCanonicalSubscription(String canonicalSubscription) {
        Preconditions.checkArgument((boolean)PATTERN.matcher(canonicalSubscription).matches(), (String)"malformed subscription: %s", (Object[])new Object[]{canonicalSubscription});
    }
}

