/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.spotify.google.cloud.pubsub.client.PushConfig;
import com.spotify.google.cloud.pubsub.client.Subscription;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;

public final class SubscriptionBuilder {
    private String name;
    private String topic;
    private Optional<PushConfig> pushConfig;
    private Optional<Integer> ackDeadlineSeconds;

    public SubscriptionBuilder() {
        this.pushConfig = Optional.empty();
        this.ackDeadlineSeconds = Optional.empty();
    }

    private SubscriptionBuilder(Subscription v) {
        this.name = v.name();
        this.topic = v.topic();
        this.pushConfig = v.pushConfig();
        this.ackDeadlineSeconds = v.ackDeadlineSeconds();
    }

    private SubscriptionBuilder(SubscriptionBuilder v) {
        this.name = v.name;
        this.topic = v.topic;
        this.pushConfig = v.pushConfig;
        this.ackDeadlineSeconds = v.ackDeadlineSeconds;
    }

    public String name() {
        return this.name;
    }

    public SubscriptionBuilder name(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
        return this;
    }

    public String topic() {
        return this.topic;
    }

    public SubscriptionBuilder topic(String topic) {
        if (topic == null) {
            throw new NullPointerException("topic");
        }
        this.topic = topic;
        return this;
    }

    public Optional<PushConfig> pushConfig() {
        return this.pushConfig;
    }

    public SubscriptionBuilder pushConfig(PushConfig pushConfig) {
        return this.pushConfig(Optional.ofNullable(pushConfig));
    }

    public SubscriptionBuilder pushConfig(Optional<? extends PushConfig> pushConfig) {
        if (pushConfig == null) {
            throw new NullPointerException("pushConfig");
        }
        this.pushConfig = pushConfig;
        return this;
    }

    public Optional<Integer> ackDeadlineSeconds() {
        return this.ackDeadlineSeconds;
    }

    public SubscriptionBuilder ackDeadlineSeconds(Integer ackDeadlineSeconds) {
        return this.ackDeadlineSeconds(Optional.ofNullable(ackDeadlineSeconds));
    }

    public SubscriptionBuilder ackDeadlineSeconds(Optional<? extends Integer> ackDeadlineSeconds) {
        if (ackDeadlineSeconds == null) {
            throw new NullPointerException("ackDeadlineSeconds");
        }
        this.ackDeadlineSeconds = ackDeadlineSeconds;
        return this;
    }

    public Subscription build() {
        return new Value(this.name, this.topic, this.pushConfig, this.ackDeadlineSeconds);
    }

    public static SubscriptionBuilder from(Subscription v) {
        return new SubscriptionBuilder(v);
    }

    public static SubscriptionBuilder from(SubscriptionBuilder v) {
        return new SubscriptionBuilder(v);
    }

    private static final class Value
    implements Subscription {
        private final String name;
        private final String topic;
        private final Optional<PushConfig> pushConfig;
        private final Optional<Integer> ackDeadlineSeconds;

        private Value(@AutoMatter.Field(value="name") String name, @AutoMatter.Field(value="topic") String topic, @AutoMatter.Field(value="pushConfig") Optional<PushConfig> pushConfig, @AutoMatter.Field(value="ackDeadlineSeconds") Optional<Integer> ackDeadlineSeconds) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (topic == null) {
                throw new NullPointerException("topic");
            }
            if (pushConfig == null) {
                throw new NullPointerException("pushConfig");
            }
            if (ackDeadlineSeconds == null) {
                throw new NullPointerException("ackDeadlineSeconds");
            }
            this.name = name;
            this.topic = topic;
            this.pushConfig = pushConfig;
            this.ackDeadlineSeconds = ackDeadlineSeconds;
        }

        @Override
        @AutoMatter.Field
        public String name() {
            return this.name;
        }

        @Override
        @AutoMatter.Field
        public String topic() {
            return this.topic;
        }

        @Override
        @AutoMatter.Field
        public Optional<PushConfig> pushConfig() {
            return this.pushConfig;
        }

        @Override
        @AutoMatter.Field
        public Optional<Integer> ackDeadlineSeconds() {
            return this.ackDeadlineSeconds;
        }

        @Override
        public SubscriptionBuilder builder() {
            return new SubscriptionBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Subscription)) {
                return false;
            }
            Subscription that = (Subscription)o;
            if (this.name != null ? !this.name.equals(that.name()) : that.name() != null) {
                return false;
            }
            if (this.topic != null ? !this.topic.equals(that.topic()) : that.topic() != null) {
                return false;
            }
            if (this.pushConfig != null ? !this.pushConfig.equals(that.pushConfig()) : that.pushConfig() != null) {
                return false;
            }
            return !(this.ackDeadlineSeconds != null ? !this.ackDeadlineSeconds.equals(that.ackDeadlineSeconds()) : that.ackDeadlineSeconds() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
            result = 31 * result + (this.pushConfig != null ? this.pushConfig.hashCode() : 0);
            result = 31 * result + (this.ackDeadlineSeconds != null ? this.ackDeadlineSeconds.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Subscription{name=" + this.name + ", topic=" + this.topic + ", pushConfig=" + this.pushConfig + ", ackDeadlineSeconds=" + this.ackDeadlineSeconds + '}';
        }
    }
}

