/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.spotify.google.cloud.pubsub.client.PushConfig;
import com.spotify.google.cloud.pubsub.client.SubscriptionCreateRequest;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;

final class SubscriptionCreateRequestBuilder {
    private String topic;
    private Optional<PushConfig> pushConfig;
    private Optional<Integer> ackDeadlineSeconds;

    public SubscriptionCreateRequestBuilder() {
        this.pushConfig = Optional.empty();
        this.ackDeadlineSeconds = Optional.empty();
    }

    private SubscriptionCreateRequestBuilder(SubscriptionCreateRequest v) {
        this.topic = v.topic();
        this.pushConfig = v.pushConfig();
        this.ackDeadlineSeconds = v.ackDeadlineSeconds();
    }

    private SubscriptionCreateRequestBuilder(SubscriptionCreateRequestBuilder v) {
        this.topic = v.topic;
        this.pushConfig = v.pushConfig;
        this.ackDeadlineSeconds = v.ackDeadlineSeconds;
    }

    public String topic() {
        return this.topic;
    }

    public SubscriptionCreateRequestBuilder topic(String topic) {
        if (topic == null) {
            throw new NullPointerException("topic");
        }
        this.topic = topic;
        return this;
    }

    public Optional<PushConfig> pushConfig() {
        return this.pushConfig;
    }

    public SubscriptionCreateRequestBuilder pushConfig(PushConfig pushConfig) {
        return this.pushConfig(Optional.ofNullable(pushConfig));
    }

    public SubscriptionCreateRequestBuilder pushConfig(Optional<? extends PushConfig> pushConfig) {
        if (pushConfig == null) {
            throw new NullPointerException("pushConfig");
        }
        this.pushConfig = pushConfig;
        return this;
    }

    public Optional<Integer> ackDeadlineSeconds() {
        return this.ackDeadlineSeconds;
    }

    public SubscriptionCreateRequestBuilder ackDeadlineSeconds(Integer ackDeadlineSeconds) {
        return this.ackDeadlineSeconds(Optional.ofNullable(ackDeadlineSeconds));
    }

    public SubscriptionCreateRequestBuilder ackDeadlineSeconds(Optional<? extends Integer> ackDeadlineSeconds) {
        if (ackDeadlineSeconds == null) {
            throw new NullPointerException("ackDeadlineSeconds");
        }
        this.ackDeadlineSeconds = ackDeadlineSeconds;
        return this;
    }

    public SubscriptionCreateRequest build() {
        return new Value(this.topic, this.pushConfig, this.ackDeadlineSeconds);
    }

    public static SubscriptionCreateRequestBuilder from(SubscriptionCreateRequest v) {
        return new SubscriptionCreateRequestBuilder(v);
    }

    public static SubscriptionCreateRequestBuilder from(SubscriptionCreateRequestBuilder v) {
        return new SubscriptionCreateRequestBuilder(v);
    }

    private static final class Value
    implements SubscriptionCreateRequest {
        private final String topic;
        private final Optional<PushConfig> pushConfig;
        private final Optional<Integer> ackDeadlineSeconds;

        private Value(@AutoMatter.Field(value="topic") String topic, @AutoMatter.Field(value="pushConfig") Optional<PushConfig> pushConfig, @AutoMatter.Field(value="ackDeadlineSeconds") Optional<Integer> ackDeadlineSeconds) {
            if (topic == null) {
                throw new NullPointerException("topic");
            }
            if (pushConfig == null) {
                throw new NullPointerException("pushConfig");
            }
            if (ackDeadlineSeconds == null) {
                throw new NullPointerException("ackDeadlineSeconds");
            }
            this.topic = topic;
            this.pushConfig = pushConfig;
            this.ackDeadlineSeconds = ackDeadlineSeconds;
        }

        @Override
        @AutoMatter.Field
        public String topic() {
            return this.topic;
        }

        @Override
        @AutoMatter.Field
        public Optional<PushConfig> pushConfig() {
            return this.pushConfig;
        }

        @Override
        @AutoMatter.Field
        public Optional<Integer> ackDeadlineSeconds() {
            return this.ackDeadlineSeconds;
        }

        @Override
        public SubscriptionCreateRequestBuilder builder() {
            return new SubscriptionCreateRequestBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SubscriptionCreateRequest)) {
                return false;
            }
            SubscriptionCreateRequest that = (SubscriptionCreateRequest)o;
            if (this.topic != null ? !this.topic.equals(that.topic()) : that.topic() != null) {
                return false;
            }
            if (this.pushConfig != null ? !this.pushConfig.equals(that.pushConfig()) : that.pushConfig() != null) {
                return false;
            }
            return !(this.ackDeadlineSeconds != null ? !this.ackDeadlineSeconds.equals(that.ackDeadlineSeconds()) : that.ackDeadlineSeconds() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
            result = 31 * result + (this.pushConfig != null ? this.pushConfig.hashCode() : 0);
            result = 31 * result + (this.ackDeadlineSeconds != null ? this.ackDeadlineSeconds.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "SubscriptionCreateRequest{topic=" + this.topic + ", pushConfig=" + this.pushConfig + ", ackDeadlineSeconds=" + this.ackDeadlineSeconds + '}';
        }
    }
}

