/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.spotify.google.cloud.pubsub.client.Subscription;
import com.spotify.google.cloud.pubsub.client.SubscriptionList;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public final class SubscriptionListBuilder {
    private List<Subscription> subscriptions;
    private Optional<String> nextPageToken;

    public SubscriptionListBuilder() {
        this.nextPageToken = Optional.empty();
    }

    private SubscriptionListBuilder(SubscriptionList v) {
        List<Subscription> _subscriptions = v.subscriptions();
        this.subscriptions = _subscriptions == null ? null : new ArrayList<Subscription>(_subscriptions);
        this.nextPageToken = v.nextPageToken();
    }

    private SubscriptionListBuilder(SubscriptionListBuilder v) {
        this.subscriptions = v.subscriptions == null ? null : new ArrayList<Subscription>(v.subscriptions);
        this.nextPageToken = v.nextPageToken;
    }

    public List<Subscription> subscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<Subscription>();
        }
        return this.subscriptions;
    }

    public SubscriptionListBuilder subscriptions(List<? extends Subscription> subscriptions) {
        return this.subscriptions((Collection<? extends Subscription>)subscriptions);
    }

    public SubscriptionListBuilder subscriptions(Collection<? extends Subscription> subscriptions) {
        if (subscriptions == null) {
            throw new NullPointerException("subscriptions");
        }
        for (Subscription subscription : subscriptions) {
            if (subscription != null) continue;
            throw new NullPointerException("subscriptions: null item");
        }
        this.subscriptions = new ArrayList<Subscription>(subscriptions);
        return this;
    }

    public SubscriptionListBuilder subscriptions(Iterable<? extends Subscription> subscriptions) {
        if (subscriptions == null) {
            throw new NullPointerException("subscriptions");
        }
        if (subscriptions instanceof Collection) {
            return this.subscriptions((Collection)subscriptions);
        }
        return this.subscriptions(subscriptions.iterator());
    }

    public SubscriptionListBuilder subscriptions(Iterator<? extends Subscription> subscriptions) {
        if (subscriptions == null) {
            throw new NullPointerException("subscriptions");
        }
        this.subscriptions = new ArrayList<Subscription>();
        while (subscriptions.hasNext()) {
            Subscription item = subscriptions.next();
            if (item == null) {
                throw new NullPointerException("subscriptions: null item");
            }
            this.subscriptions.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final SubscriptionListBuilder subscriptions(Subscription ... subscriptions) {
        if (subscriptions == null) {
            throw new NullPointerException("subscriptions");
        }
        return this.subscriptions(Arrays.asList(subscriptions));
    }

    public SubscriptionListBuilder addSubscription(Subscription subscription) {
        if (subscription == null) {
            throw new NullPointerException("subscription");
        }
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<Subscription>();
        }
        this.subscriptions.add(subscription);
        return this;
    }

    public Optional<String> nextPageToken() {
        return this.nextPageToken;
    }

    public SubscriptionListBuilder nextPageToken(String nextPageToken) {
        return this.nextPageToken(Optional.ofNullable(nextPageToken));
    }

    public SubscriptionListBuilder nextPageToken(Optional<? extends String> nextPageToken) {
        if (nextPageToken == null) {
            throw new NullPointerException("nextPageToken");
        }
        this.nextPageToken = nextPageToken;
        return this;
    }

    public SubscriptionList build() {
        List _subscriptions = this.subscriptions != null ? Collections.unmodifiableList(new ArrayList<Subscription>(this.subscriptions)) : Collections.emptyList();
        return new Value(_subscriptions, this.nextPageToken);
    }

    public static SubscriptionListBuilder from(SubscriptionList v) {
        return new SubscriptionListBuilder(v);
    }

    public static SubscriptionListBuilder from(SubscriptionListBuilder v) {
        return new SubscriptionListBuilder(v);
    }

    private static final class Value
    implements SubscriptionList {
        private final List<Subscription> subscriptions;
        private final Optional<String> nextPageToken;

        private Value(@AutoMatter.Field(value="subscriptions") List<Subscription> subscriptions, @AutoMatter.Field(value="nextPageToken") Optional<String> nextPageToken) {
            if (nextPageToken == null) {
                throw new NullPointerException("nextPageToken");
            }
            this.subscriptions = subscriptions != null ? subscriptions : Collections.emptyList();
            this.nextPageToken = nextPageToken;
        }

        @Override
        @AutoMatter.Field
        public List<Subscription> subscriptions() {
            return this.subscriptions;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> nextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public SubscriptionListBuilder builder() {
            return new SubscriptionListBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SubscriptionList)) {
                return false;
            }
            SubscriptionList that = (SubscriptionList)o;
            if (this.subscriptions != null ? !this.subscriptions.equals(that.subscriptions()) : that.subscriptions() != null) {
                return false;
            }
            return !(this.nextPageToken != null ? !this.nextPageToken.equals(that.nextPageToken()) : that.nextPageToken() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.subscriptions != null ? this.subscriptions.hashCode() : 0);
            result = 31 * result + (this.nextPageToken != null ? this.nextPageToken.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "SubscriptionList{subscriptions=" + this.subscriptions + ", nextPageToken=" + this.nextPageToken + '}';
        }
    }
}

