/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.spotify.google.cloud.pubsub.client.TopicBuilder;
import io.norberg.automatter.AutoMatter;
import java.util.regex.Pattern;

@AutoMatter
public interface Topic {
    public static final Pattern PATTERN = Pattern.compile("^projects/[^/]*/topics/[^/]*$");
    public static final String PROJECTS = "projects";
    public static final String TOPICS = "topics";

    public String name();

    public static TopicBuilder builder() {
        return new TopicBuilder();
    }

    public static Topic of(String project, String topic) {
        return Topic.of(Topic.canonicalTopic(project, topic));
    }

    public static Topic of(String canonicalTopic) {
        return Topic.builder().name(canonicalTopic).build();
    }

    public static String canonicalTopic(String project, String topic) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)project) && !project.contains("/") ? 1 : 0) != 0, (String)"illegal project: %s", (Object[])new Object[]{project});
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)topic) && !topic.contains("/") ? 1 : 0) != 0, (String)"illegal topic: %s", (Object[])new Object[]{topic});
        return "projects/" + project + '/' + TOPICS + '/' + topic;
    }

    public static void validateCanonicalTopic(String canonicalTopic) {
        Preconditions.checkArgument((boolean)PATTERN.matcher(canonicalTopic).matches(), (String)"malformed topic: %s", (Object[])new Object[]{canonicalTopic});
    }
}

