/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.spotify.google.cloud.pubsub.client.Topic;
import io.norberg.automatter.AutoMatter;

public final class TopicBuilder {
    private String name;

    public TopicBuilder() {
    }

    private TopicBuilder(Topic v) {
        this.name = v.name();
    }

    private TopicBuilder(TopicBuilder v) {
        this.name = v.name;
    }

    public String name() {
        return this.name;
    }

    public TopicBuilder name(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
        return this;
    }

    public Topic build() {
        return new Value(this.name);
    }

    public static TopicBuilder from(Topic v) {
        return new TopicBuilder(v);
    }

    public static TopicBuilder from(TopicBuilder v) {
        return new TopicBuilder(v);
    }

    private static final class Value
    implements Topic {
        private final String name;

        private Value(@AutoMatter.Field(value="name") String name) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            this.name = name;
        }

        @Override
        @AutoMatter.Field
        public String name() {
            return this.name;
        }

        @Override
        public TopicBuilder builder() {
            return new TopicBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Topic)) {
                return false;
            }
            Topic that = (Topic)o;
            return !(this.name != null ? !this.name.equals(that.name()) : that.name() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Topic{name=" + this.name + '}';
        }
    }
}

