/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.google.cloud.pubsub.client;

import com.spotify.google.cloud.pubsub.client.Topic;
import com.spotify.google.cloud.pubsub.client.TopicList;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public final class TopicListBuilder {
    private List<Topic> topics;
    private Optional<String> nextPageToken;

    public TopicListBuilder() {
        this.nextPageToken = Optional.empty();
    }

    private TopicListBuilder(TopicList v) {
        List<Topic> _topics = v.topics();
        this.topics = _topics == null ? null : new ArrayList<Topic>(_topics);
        this.nextPageToken = v.nextPageToken();
    }

    private TopicListBuilder(TopicListBuilder v) {
        this.topics = v.topics == null ? null : new ArrayList<Topic>(v.topics);
        this.nextPageToken = v.nextPageToken;
    }

    public List<Topic> topics() {
        if (this.topics == null) {
            this.topics = new ArrayList<Topic>();
        }
        return this.topics;
    }

    public TopicListBuilder topics(List<? extends Topic> topics) {
        return this.topics((Collection<? extends Topic>)topics);
    }

    public TopicListBuilder topics(Collection<? extends Topic> topics) {
        if (topics == null) {
            throw new NullPointerException("topics");
        }
        for (Topic topic : topics) {
            if (topic != null) continue;
            throw new NullPointerException("topics: null item");
        }
        this.topics = new ArrayList<Topic>(topics);
        return this;
    }

    public TopicListBuilder topics(Iterable<? extends Topic> topics) {
        if (topics == null) {
            throw new NullPointerException("topics");
        }
        if (topics instanceof Collection) {
            return this.topics((Collection)topics);
        }
        return this.topics(topics.iterator());
    }

    public TopicListBuilder topics(Iterator<? extends Topic> topics) {
        if (topics == null) {
            throw new NullPointerException("topics");
        }
        this.topics = new ArrayList<Topic>();
        while (topics.hasNext()) {
            Topic item = topics.next();
            if (item == null) {
                throw new NullPointerException("topics: null item");
            }
            this.topics.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final TopicListBuilder topics(Topic ... topics) {
        if (topics == null) {
            throw new NullPointerException("topics");
        }
        return this.topics(Arrays.asList(topics));
    }

    public TopicListBuilder addTopic(Topic topic) {
        if (topic == null) {
            throw new NullPointerException("topic");
        }
        if (this.topics == null) {
            this.topics = new ArrayList<Topic>();
        }
        this.topics.add(topic);
        return this;
    }

    public Optional<String> nextPageToken() {
        return this.nextPageToken;
    }

    public TopicListBuilder nextPageToken(String nextPageToken) {
        return this.nextPageToken(Optional.ofNullable(nextPageToken));
    }

    public TopicListBuilder nextPageToken(Optional<? extends String> nextPageToken) {
        if (nextPageToken == null) {
            throw new NullPointerException("nextPageToken");
        }
        this.nextPageToken = nextPageToken;
        return this;
    }

    public TopicList build() {
        List _topics = this.topics != null ? Collections.unmodifiableList(new ArrayList<Topic>(this.topics)) : Collections.emptyList();
        return new Value(_topics, this.nextPageToken);
    }

    public static TopicListBuilder from(TopicList v) {
        return new TopicListBuilder(v);
    }

    public static TopicListBuilder from(TopicListBuilder v) {
        return new TopicListBuilder(v);
    }

    private static final class Value
    implements TopicList {
        private final List<Topic> topics;
        private final Optional<String> nextPageToken;

        private Value(@AutoMatter.Field(value="topics") List<Topic> topics, @AutoMatter.Field(value="nextPageToken") Optional<String> nextPageToken) {
            if (nextPageToken == null) {
                throw new NullPointerException("nextPageToken");
            }
            this.topics = topics != null ? topics : Collections.emptyList();
            this.nextPageToken = nextPageToken;
        }

        @Override
        @AutoMatter.Field
        public List<Topic> topics() {
            return this.topics;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> nextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public TopicListBuilder builder() {
            return new TopicListBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TopicList)) {
                return false;
            }
            TopicList that = (TopicList)o;
            if (this.topics != null ? !this.topics.equals(that.topics()) : that.topics() != null) {
                return false;
            }
            return !(this.nextPageToken != null ? !this.nextPageToken.equals(that.nextPageToken()) : that.nextPageToken() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.topics != null ? this.topics.hashCode() : 0);
            result = 31 * result + (this.nextPageToken != null ? this.nextPageToken.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "TopicList{topics=" + this.topics + ", nextPageToken=" + this.nextPageToken + '}';
        }
    }
}

