/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.spotify.dns.DnsSrvResolver;
import com.spotify.dns.LookupResult;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class RetainingDnsSrvResolver
implements DnsSrvResolver {
    private final DnsSrvResolver delegate;
    private final Map<String, List<LookupResult>> cache;

    RetainingDnsSrvResolver(DnsSrvResolver delegate) {
        this.delegate = (DnsSrvResolver)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        this.cache = new ConcurrentHashMap<String, List<LookupResult>>();
    }

    @Override
    public List<LookupResult> resolve(String fqdn) {
        Preconditions.checkNotNull((Object)fqdn, (Object)"fqdn");
        try {
            List nodes = this.delegate.resolve(fqdn);
            if (nodes.isEmpty()) {
                nodes = (List)MoreObjects.firstNonNull(this.cache.get(fqdn), nodes);
            } else {
                this.cache.put(fqdn, nodes);
            }
            return nodes;
        }
        catch (Exception e) {
            if (this.cache.containsKey(fqdn)) {
                return this.cache.get(fqdn);
            }
            throw Throwables.propagate((Throwable)e);
        }
    }
}

