/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.spotify.dns.AbstractChangeNotifier;
import com.spotify.dns.ChangeNotifier;
import com.spotify.dns.ChangeNotifierFactory;
import com.spotify.dns.DnsException;
import com.spotify.dns.DnsSrvResolver;
import com.spotify.dns.ErrorHandler;
import com.spotify.dns.LookupResult;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceResolvingChangeNotifier<T>
extends AbstractChangeNotifier<T>
implements ChangeNotifierFactory.RunnableChangeNotifier<T> {
    private static final Logger log = LoggerFactory.getLogger(ServiceResolvingChangeNotifier.class);
    private final DnsSrvResolver resolver;
    private final String fqdn;
    private final Function<LookupResult, T> resultTransformer;
    @Nullable
    private final ErrorHandler errorHandler;
    private volatile Set<T> records = ImmutableSet.of();
    private volatile boolean run = true;

    ServiceResolvingChangeNotifier(DnsSrvResolver resolver, String fqdn, Function<LookupResult, T> resultTransformer, @Nullable ErrorHandler errorHandler) {
        this.resolver = (DnsSrvResolver)Preconditions.checkNotNull((Object)resolver);
        this.fqdn = (String)Preconditions.checkNotNull((Object)fqdn, (Object)"fqdn");
        this.resultTransformer = (Function)Preconditions.checkNotNull(resultTransformer, (Object)"resultTransformer");
        this.errorHandler = errorHandler;
    }

    @Override
    protected void closeImplementation() {
        this.run = false;
    }

    @Override
    public Set<T> current() {
        return this.records;
    }

    @Override
    public void run() {
        ImmutableSet current;
        List<LookupResult> nodes;
        if (!this.run) {
            return;
        }
        try {
            nodes = this.resolver.resolve(this.fqdn);
        }
        catch (DnsException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handle(this.fqdn, e);
            }
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
        try {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (LookupResult node : nodes) {
                Object transformed = this.resultTransformer.apply((Object)node);
                builder.add(Preconditions.checkNotNull((Object)transformed, (Object)"transformed"));
            }
            current = builder.build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
        if (!current.equals(this.records)) {
            ChangeNotifier.ChangeNotification<T> changeNotification = this.newChangeNotification(current, this.records);
            this.records = current;
            this.fireRecordsUpdated(changeNotification);
        }
    }
}

