/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import com.spotify.dns.AggregatingChangeNotifier;
import com.spotify.dns.ChangeNotifier;
import com.spotify.dns.ChangeNotifierFactory;
import com.spotify.dns.DirectChangeNotifier;
import com.spotify.dns.StaticChangeNotifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public final class ChangeNotifiers {
    private static final Set INITIAL_EMPTY_DATA = Collections.unmodifiableSet(new HashSet());

    private ChangeNotifiers() {
    }

    public static <T> boolean isInitialEmptyData(Set<T> set) {
        return set == INITIAL_EMPTY_DATA;
    }

    static <T> Set<T> initialEmptyDataInstance() {
        return INITIAL_EMPTY_DATA;
    }

    static <T> boolean isNoLongerInitial(Set<T> current, Set<T> previous) {
        return ChangeNotifiers.isInitialEmptyData(previous) && !ChangeNotifiers.isInitialEmptyData(current);
    }

    public static <T> ChangeNotifier<T> aggregate(ChangeNotifier<T> ... notifiers) {
        return ChangeNotifiers.aggregate(Arrays.asList(notifiers));
    }

    public static <T> ChangeNotifier<T> aggregate(Iterable<ChangeNotifier<T>> notifiers) {
        return new AggregatingChangeNotifier<T>(notifiers);
    }

    public static <T> ChangeNotifier<T> staticRecords(T ... records) {
        return ChangeNotifiers.staticRecords(Sets.newHashSet((Object[])records));
    }

    public static <T> ChangeNotifier<T> staticRecords(Set<T> records) {
        return new StaticChangeNotifier<T>(records);
    }

    public static <T> ChangeNotifierFactory.RunnableChangeNotifier<T> direct(Supplier<Set<T>> recordsSupplier) {
        return new DirectChangeNotifier<T>(recordsSupplier);
    }

    public static <T> ChangeNotifierFactory.RunnableChangeNotifier<T> direct(AtomicReference<Set<T>> recordsHolder) {
        return new DirectChangeNotifier<T>(ChangeNotifiers.supplierFromRef(recordsHolder));
    }

    private static <T> Supplier<Set<T>> supplierFromRef(final AtomicReference<Set<T>> ref) {
        Preconditions.checkNotNull(ref, (Object)"ref");
        return new Supplier<Set<T>>(){

            public Set<T> get() {
                return (Set)ref.get();
            }
        };
    }
}

