/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.spotify.dns.AbstractChangeNotifier;
import com.spotify.dns.ChangeNotifier;
import com.spotify.dns.ChangeNotifierFactory;
import com.spotify.dns.ChangeNotifiers;
import java.util.Set;

class DirectChangeNotifier<T>
extends AbstractChangeNotifier<T>
implements ChangeNotifierFactory.RunnableChangeNotifier<T> {
    private final Supplier<Set<T>> recordsSupplier;
    private volatile Set<T> records = ChangeNotifiers.initialEmptyDataInstance();
    private volatile boolean run = true;

    public DirectChangeNotifier(Supplier<Set<T>> recordsSupplier) {
        this.recordsSupplier = (Supplier)Preconditions.checkNotNull(recordsSupplier, (Object)"recordsSupplier");
    }

    @Override
    protected void closeImplementation() {
        this.run = false;
    }

    @Override
    public Set<T> current() {
        return this.records;
    }

    @Override
    public void run() {
        if (!this.run) {
            return;
        }
        Set current = (Set)this.recordsSupplier.get();
        if (ChangeNotifiers.isNoLongerInitial(current, this.records) || !current.equals(this.records)) {
            ChangeNotifier.ChangeNotification<T> changeNotification = this.newChangeNotification(current, this.records);
            this.records = current;
            this.fireRecordsUpdated(changeNotification);
        }
    }
}

