/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.google.common.collect.ImmutableSet;
import com.spotify.dns.AbstractChangeNotifier;
import com.spotify.dns.ChangeNotifier;
import com.spotify.dns.ChangeNotifierFactory;
import com.spotify.dns.ChangeNotifiers;
import com.spotify.dns.DnsException;
import com.spotify.dns.DnsSrvResolver;
import com.spotify.dns.ErrorHandler;
import com.spotify.dns.LookupResult;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceResolvingChangeNotifier<T>
extends AbstractChangeNotifier<T>
implements ChangeNotifierFactory.RunnableChangeNotifier<T> {
    private static final Logger log = LoggerFactory.getLogger(ServiceResolvingChangeNotifier.class);
    private final DnsSrvResolver resolver;
    private final String fqdn;
    private final Function<LookupResult, T> resultTransformer;
    private final ErrorHandler errorHandler;
    private volatile Set<T> records = ChangeNotifiers.initialEmptyDataInstance();
    private volatile boolean waitingForFirstEvent = true;
    private volatile boolean run = true;

    ServiceResolvingChangeNotifier(DnsSrvResolver resolver, String fqdn, Function<LookupResult, T> resultTransformer, ErrorHandler errorHandler) {
        this.resolver = Objects.requireNonNull(resolver, "resolver");
        this.fqdn = Objects.requireNonNull(fqdn, "fqdn");
        this.resultTransformer = Objects.requireNonNull(resultTransformer, "resultTransformer");
        this.errorHandler = errorHandler;
    }

    @Override
    protected void closeImplementation() {
        this.run = false;
    }

    @Override
    public Set<T> current() {
        return this.records;
    }

    @Override
    public void run() {
        if (!this.run) {
            return;
        }
        this.resolver.resolveAsync(this.fqdn).whenComplete((nodes, e) -> {
            if (e instanceof DnsException) {
                if (this.errorHandler != null) {
                    this.errorHandler.handle(this.fqdn, (DnsException)e);
                }
                log.error(e.getMessage(), e);
                this.fireIfFirstError();
            } else if (e != null) {
                log.error(e.getMessage(), e);
                this.fireIfFirstError();
            } else {
                ImmutableSet current;
                try {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    for (LookupResult node : nodes) {
                        T transformed = this.resultTransformer.apply(node);
                        builder.add(Objects.requireNonNull(transformed, "transformed"));
                    }
                    current = builder.build();
                }
                catch (Exception transformerException) {
                    log.error(transformerException.getMessage(), (Throwable)transformerException);
                    this.fireIfFirstError();
                    return;
                }
                if (ChangeNotifiers.isNoLongerInitial(current, this.records) || !current.equals(this.records)) {
                    this.waitingForFirstEvent = false;
                    ChangeNotifier.ChangeNotification<T> changeNotification = this.newChangeNotification(current, this.records);
                    this.records = current;
                    this.fireRecordsUpdated(changeNotification);
                }
            }
        });
    }

    private void fireIfFirstError() {
        if (this.waitingForFirstEvent) {
            this.waitingForFirstEvent = false;
            Set<T> previous = this.current();
            this.records = ImmutableSet.of();
            this.fireRecordsUpdated(this.newChangeNotification(this.records, previous));
        }
    }
}

