/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docgenerator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.auto.service.AutoService;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.spotify.docgenerator.ResourceArgument;
import com.spotify.docgenerator.ResourceClass;
import com.spotify.docgenerator.ResourceMethod;
import com.spotify.docgenerator.TransferClass;
import com.spotify.docgenerator.TypeDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@SupportedAnnotationTypes(value={"com.fasterxml.jackson.annotation.JsonProperty", "com.fasterxml.jackson.databind.annotation.JsonSerialize", "javax.ws.rs.GET", "javax.ws.rs.POST", "javax.ws.rs.PUT", "javax.ws.rs.DELETE", "com.spotify.helios.master.http.PATCH"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedOptions(value={"debug", "verify"})
@AutoService(value=Processor.class)
public class JacksonJerseyAnnotationProcessor
extends AbstractProcessor {
    private static final List<String> METHOD_ANNOTATIONS = Lists.newArrayList((Object[])new String[]{"javax.ws.rs.GET", "javax.ws.rs.POST", "javax.ws.rs.PUT", "javax.ws.rs.DELETE", "com.spotify.helios.master.http.PATCH"});
    private static final ObjectWriter NORMALIZING_OBJECT_WRITER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).writer();
    private final Map<String, TransferClass> jsonClasses = Maps.newHashMap();
    private final Map<String, ResourceClass> resourceClasses = Maps.newHashMap();
    private final List<String> debugMessages = Lists.newArrayList();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateOutput();
        } else {
            this.processAnnotations(annotations, roundEnv);
        }
        return true;
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processJacksonAnnotations(roundEnv);
        this.processRESTEndpointAnnotations(annotations, roundEnv);
    }

    private void processRESTEndpointAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (String methodAnnotation : METHOD_ANNOTATIONS) {
            for (TypeElement typeElement : annotations) {
                if (!typeElement.toString().equals(methodAnnotation)) continue;
                this.processFoundRestAnnotations(typeElement, roundEnv);
            }
        }
    }

    private void processFoundRestAnnotations(TypeElement foundAnnotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(foundAnnotations);
        for (Element element : elements) {
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement ee = (ExecutableElement)element;
            List<ResourceArgument> arguments = this.computeMethodArguments(ee);
            ResourceMethod method = this.computeMethod(ee, arguments);
            ResourceClass klass = this.getParentResourceClass(element);
            klass.getMembers().add(method);
        }
    }

    private List<ResourceArgument> computeMethodArguments(ExecutableElement ee) {
        ArrayList arguments = Lists.newArrayList();
        for (VariableElement variableElement : ee.getParameters()) {
            PathParam pathAnnotation = variableElement.getAnnotation(PathParam.class);
            String argName = pathAnnotation != null ? pathAnnotation.value() : variableElement.getSimpleName().toString();
            arguments.add(new ResourceArgument(argName, this.makeTypeDescriptor(variableElement.asType())));
        }
        return arguments;
    }

    private ResourceMethod computeMethod(ExecutableElement ee, List<ResourceArgument> arguments) {
        String javaDoc = this.processingEnv.getElementUtils().getDocComment(ee);
        Path pathAnnotation = ee.getAnnotation(Path.class);
        Produces producesAnnotation = ee.getAnnotation(Produces.class);
        return new ResourceMethod(ee.getSimpleName().toString(), this.computeRequestMethod(ee), pathAnnotation == null ? null : pathAnnotation.value(), producesAnnotation == null ? null : Joiner.on((String)",").join((Object[])producesAnnotation.value()), this.makeTypeDescriptor(ee.getReturnType()), arguments, javaDoc);
    }

    private String computeRequestMethod(Element e) {
        for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
            String typeString = annotationMirror.getAnnotationType().toString();
            if (typeString.endsWith(".GET")) {
                return "GET";
            }
            if (typeString.endsWith(".PUT")) {
                return "PUT";
            }
            if (typeString.endsWith(".POST")) {
                return "POST";
            }
            if (typeString.endsWith(".PATCH")) {
                return "PATCH";
            }
            if (!typeString.endsWith(".DELETE")) continue;
            return "DELETE";
        }
        return null;
    }

    private ResourceClass getParentResourceClass(Element e) {
        String parentClassName = e.getEnclosingElement().toString();
        ResourceClass klass = this.resourceClasses.get(parentClassName);
        if (klass != null) {
            return klass;
        }
        Path klassPath = e.getEnclosingElement().getAnnotation(Path.class);
        ResourceClass newKlass = new ResourceClass(klassPath == null ? null : klassPath.value(), (List)Lists.newArrayList());
        this.resourceClasses.put(parentClassName, newKlass);
        return newKlass;
    }

    private void processJacksonAnnotations(RoundEnvironment roundEnv) {
        this.processJsonPropertyAnnotations(roundEnv);
        this.processJsonSerializeAnnotations(roundEnv);
    }

    private void processJsonPropertyAnnotations(RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(JsonProperty.class);
        for (Element element : elements) {
            Element parentElement;
            if (element.getEnclosingElement() == null || (parentElement = element.getEnclosingElement().getEnclosingElement()) == null || !(parentElement instanceof TypeElement)) continue;
            TypeElement parent = (TypeElement)parentElement;
            String parentJavaDoc = this.processingEnv.getElementUtils().getDocComment(parent);
            String parentName = parent.getQualifiedName().toString();
            TransferClass klass = this.getOrCreateTransferClass(parentName, parentJavaDoc);
            klass.add(element.toString(), this.makeTypeDescriptor(element.asType()));
        }
    }

    private void processJsonSerializeAnnotations(RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(JsonSerialize.class);
        for (Element element : elements) {
            if (element.getKind() != ElementKind.CLASS) {
                this.debugMessages.add("kind for " + element + " is not CLASS, but " + (Object)((Object)element.getKind()));
                continue;
            }
            TypeElement te = (TypeElement)element;
            String className = te.getQualifiedName().toString();
            if (this.jsonClasses.containsKey(className)) continue;
            this.getOrCreateTransferClass(className, this.processingEnv.getElementUtils().getDocComment(te));
        }
    }

    private TransferClass getOrCreateTransferClass(String parentName, String parentJavaDoc) {
        TransferClass klass = this.jsonClasses.get(parentName);
        if (klass != null) {
            return klass;
        }
        TransferClass newKlass = new TransferClass((List)Lists.newArrayList(), parentJavaDoc);
        this.jsonClasses.put(parentName, newKlass);
        return newKlass;
    }

    private TypeDescriptor makeTypeDescriptor(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return new TypeDescriptor(type.toString(), (List)ImmutableList.of());
        }
        DeclaredType dt = (DeclaredType)type;
        String plainType = this.processingEnv.getTypeUtils().erasure(type).toString();
        ArrayList typeArgumentsList = Lists.newArrayList();
        List<? extends TypeMirror> typeArguments = dt.getTypeArguments();
        for (TypeMirror typeMirror : typeArguments) {
            typeArgumentsList.add(this.makeTypeDescriptor(typeMirror));
        }
        return new TypeDescriptor(plainType, (List)typeArgumentsList);
    }

    private void fatalError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg);
    }

    private void generateOutput() {
        Filer filer = this.processingEnv.getFiler();
        this.writeJsonToFile(filer, "JSONClasses", this.jsonClasses);
        this.writeJsonToFile(filer, "debugcrud", this.debugMessages);
        ArrayList resources = Lists.newArrayList();
        for (ResourceClass klass : this.resourceClasses.values()) {
            String path = klass.getPath();
            for (ResourceMethod method : klass.getMembers()) {
                resources.add(new ResourceMethod("", method.getMethod(), this.computeDisplayPath(path, method.getPath()), method.getReturnContentType(), method.getReturnType(), method.getArguments(), method.getJavadoc()));
            }
        }
        this.writeJsonToFile(filer, "RESTEndpoints", resources);
    }

    private String computeDisplayPath(String path, String methodPath) {
        String rootPath = !path.startsWith("/") ? "/" + path : path;
        if (methodPath == null) {
            return rootPath;
        }
        if (rootPath.endsWith("/") != methodPath.startsWith("/")) {
            return rootPath + methodPath;
        }
        if (rootPath.endsWith("/")) {
            return rootPath + methodPath.substring(1);
        }
        return rootPath + "/" + methodPath;
    }

    private void writeJsonToFile(Filer filer, String resourceFile, Object obj) {
        try {
            FileObject outputFile = filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceFile, new Element[0]);
            try (OutputStream out = outputFile.openOutputStream();){
                out.write(NORMALIZING_OBJECT_WRITER.writeValueAsBytes(obj));
            }
        }
        catch (IOException e) {
            this.fatalError("Failed writing to " + resourceFile + "\n");
            e.printStackTrace();
        }
    }
}

