/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.CharStreams;
import com.spotify.docker.client.ContainerNotFoundException;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.DockerRequestException;
import com.spotify.docker.client.DockerTimeoutException;
import com.spotify.docker.client.ImageNotFoundException;
import com.spotify.docker.client.ImagePull;
import com.spotify.docker.client.ImageRef;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.LogsResponseReader;
import com.spotify.docker.client.ObjectMapperProvider;
import com.spotify.docker.client.PullResponseReader;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerExit;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.docker.client.messages.RemovedImage;
import com.spotify.docker.client.messages.Version;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterface;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDockerClient
implements DockerClient {
    private static final long CONNECT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    private static final long READ_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private static final Logger log = LoggerFactory.getLogger(DefaultDockerClient.class);
    private static final String VERSION = "v1.12";
    private static final DefaultClientConfig CLIENT_CONFIG = new DefaultClientConfig(new Class[]{ObjectMapperProvider.class, LogsResponseReader.class, PullResponseReader.class});
    private static final Pattern CONTAINER_NAME_PATTERN = Pattern.compile("/?[a-zA-Z0-9_-]+");
    private static final GenericType<List<Container>> CONTAINER_LIST = new GenericType<List<Container>>(){};
    private static final GenericType<List<RemovedImage>> REMOVED_IMAGE_LIST = new GenericType<List<RemovedImage>>(){};
    private final Client client;
    private final URI uri;

    public DefaultDockerClient(String uri) {
        this(URI.create(uri));
    }

    public DefaultDockerClient(URI uri) {
        this.uri = uri;
        this.client = Client.create((ClientConfig)CLIENT_CONFIG);
        this.client.setConnectTimeout(Integer.valueOf((int)CONNECT_TIMEOUT_MILLIS));
        this.client.setReadTimeout(Integer.valueOf((int)READ_TIMEOUT_MILLIS));
    }

    @Override
    public Version version() throws DockerException, InterruptedException {
        WebResource resource = this.resource().path("version");
        return this.request("GET", Version.class, resource, (UniformInterface)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public List<Container> listContainers(DockerClient.ListContainersParam ... params) throws DockerException, InterruptedException {
        ArrayListMultimap paramMap = ArrayListMultimap.create();
        for (DockerClient.ListContainersParam param : params) {
            paramMap.put((Object)param.name(), (Object)param.value());
        }
        WebResource resource = this.resource().path("containers").path("json").queryParams(this.multivaluedMap((Multimap<String, String>)paramMap));
        return this.request("GET", CONTAINER_LIST, resource, resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public ContainerCreation createContainer(ContainerConfig config) throws DockerException, InterruptedException {
        return this.createContainer(config, null);
    }

    @Override
    public ContainerCreation createContainer(ContainerConfig config, String name) throws DockerException, InterruptedException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (name != null) {
            Preconditions.checkArgument((boolean)CONTAINER_NAME_PATTERN.matcher(name).matches(), (String)"Invalid container name: \"%s\"", (Object[])new Object[]{name});
            params.add((Object)"name", (Object)name);
        }
        try {
            WebResource resource = this.resource().path("containers").path("create").queryParams((MultivaluedMap)params);
            return this.request("POST", ContainerCreation.class, resource, (UniformInterface)((WebResource.Builder)resource.entity((Object)config).type(MediaType.APPLICATION_JSON_TYPE)).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(config.image(), e);
                }
            }
            throw e;
        }
    }

    @Override
    public void startContainer(String containerId) throws DockerException, InterruptedException {
        this.startContainer(containerId, HostConfig.builder().build());
    }

    @Override
    public void startContainer(String containerId, HostConfig hostConfig) throws DockerException, InterruptedException {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId");
        Preconditions.checkNotNull((Object)hostConfig, (Object)"hostConfig");
        try {
            WebResource resource = this.resource().path("containers").path(containerId).path("start");
            this.request("POST", resource, (UniformInterface)((WebResource.Builder)resource.type(MediaType.APPLICATION_JSON_TYPE).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).entity((Object)hostConfig));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void killContainer(String containerId) throws DockerException, InterruptedException {
        try {
            WebResource resource = this.resource().path("containers").path(containerId).path("kill");
            this.request("POST", resource, (UniformInterface)resource);
        }
        catch (UniformInterfaceException e) {
            switch (e.getResponse().getStatus()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw new DockerException(e);
        }
    }

    @Override
    public ContainerExit waitContainer(String containerId) throws DockerException, InterruptedException {
        try {
            WebResource resource = this.resource().path("containers").path(containerId).path("wait");
            resource.setProperty("com.sun.jersey.client.property.readTimeout", (Object)0);
            return this.request("POST", ContainerExit.class, resource, (UniformInterface)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void removeContainer(String containerId) throws DockerException, InterruptedException {
        this.removeContainer(containerId, false);
    }

    @Override
    public void removeContainer(String containerId, boolean removeVolumes) throws DockerException, InterruptedException {
        try {
            WebResource resource = this.resource().path("containers").path(containerId);
            this.request("DELETE", resource, (UniformInterface)resource.queryParam("v", String.valueOf(removeVolumes)).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (UniformInterfaceException e) {
            switch (e.getResponse().getStatus()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId);
                }
            }
            throw new DockerException(e);
        }
    }

    @Override
    public ContainerInfo inspectContainer(String containerId) throws DockerException, InterruptedException {
        try {
            WebResource resource = this.resource().path("containers").path(containerId).path("json");
            return this.request("GET", ContainerInfo.class, resource, (UniformInterface)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void pull(String image) throws DockerException, InterruptedException {
        ImageRef imageRef = new ImageRef(image);
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"fromImage", (Object)imageRef.getImage());
        if (imageRef.getTag() != null) {
            params.add((Object)"tag", (Object)imageRef.getTag());
        }
        WebResource resource = this.resource().path("images").path("create").queryParams((MultivaluedMap)params);
        try (ImagePull pull = this.request("POST", ImagePull.class, resource, (UniformInterface)resource.accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}));){
            pull.tail(image);
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(image, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void tag(String image, String name) throws DockerException, InterruptedException {
        ImageRef imageRef = new ImageRef(name);
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"repo", (Object)imageRef.getImage());
        if (imageRef.getTag() != null) {
            params.add((Object)"tag", (Object)imageRef.getTag());
        }
        WebResource resource = this.resource().path("images").path(image).path("tag").queryParams((MultivaluedMap)params);
        try {
            this.request("POST", resource, (UniformInterface)resource);
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(image, e);
                }
            }
            throw e;
        }
    }

    @Override
    public ImageInfo inspectImage(String image) throws DockerException, InterruptedException {
        try {
            WebResource resource = this.resource().path("images").path(image).path("json");
            return this.request("GET", ImageInfo.class, resource, (UniformInterface)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(image, e);
                }
            }
            throw e;
        }
    }

    @Override
    public List<RemovedImage> removeImage(String image) throws DockerException, InterruptedException {
        return this.removeImage(image, false, false);
    }

    @Override
    public List<RemovedImage> removeImage(String image, boolean force, boolean noPrune) throws DockerException, InterruptedException {
        try {
            WebResource resource = this.resource().path("images").path(image).queryParam("force", String.valueOf(force)).queryParam("noprune", String.valueOf(noPrune));
            return this.request("DELETE", REMOVED_IMAGE_LIST, resource, resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (UniformInterfaceException e) {
            switch (e.getResponse().getStatus()) {
                case 404: {
                    throw new ImageNotFoundException(image);
                }
            }
            throw new DockerException(e);
        }
    }

    @Override
    public LogStream logs(String containerId, DockerClient.LogsParameter ... params) throws DockerException, InterruptedException {
        ArrayListMultimap paramMap = ArrayListMultimap.create();
        for (DockerClient.LogsParameter param : params) {
            paramMap.put((Object)param.name().toLowerCase(Locale.ROOT), (Object)String.valueOf(true));
        }
        WebResource resource = this.resource().path("containers").path(containerId).path("logs").queryParams(this.multivaluedMap((Multimap<String, String>)paramMap));
        try {
            return this.request("GET", LogStream.class, resource, (UniformInterface)resource.accept(new String[]{"application/vnd.docker.raw-stream"}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId);
                }
            }
            throw e;
        }
    }

    private WebResource resource() {
        return this.client.resource(this.uri).path(VERSION);
    }

    private <T> T request(String method, GenericType<T> type, WebResource resource, WebResource.Builder request) throws DockerException, InterruptedException {
        try {
            return (T)request.method(method, type);
        }
        catch (ClientHandlerException e) {
            throw this.propagate(method, resource, e);
        }
        catch (UniformInterfaceException e) {
            throw this.propagate(method, resource, e);
        }
    }

    private <T> T request(String method, Class<T> clazz, WebResource resource, UniformInterface request) throws DockerException, InterruptedException {
        try {
            return (T)request.method(method, clazz);
        }
        catch (ClientHandlerException e) {
            throw this.propagate(method, resource, e);
        }
        catch (UniformInterfaceException e) {
            throw this.propagate(method, resource, e);
        }
    }

    private void request(String method, WebResource resource, UniformInterface request) throws DockerException, InterruptedException {
        try {
            request.method(method);
        }
        catch (ClientHandlerException e) {
            throw this.propagate(method, resource, e);
        }
        catch (UniformInterfaceException e) {
            throw this.propagate(method, resource, e);
        }
    }

    private DockerRequestException propagate(String method, WebResource resource, UniformInterfaceException e) {
        return new DockerRequestException(method, resource.getURI(), e.getResponse().getStatus(), this.message(e.getResponse()), e);
    }

    private RuntimeException propagate(String method, WebResource resource, ClientHandlerException e) throws DockerException, InterruptedException {
        Throwable cause = e.getCause();
        if (cause instanceof SocketTimeoutException) {
            throw new DockerTimeoutException(method, resource.getURI(), e);
        }
        if (cause instanceof InterruptedIOException) {
            throw new InterruptedException("Interrupted: " + method + " " + resource);
        }
        throw new DockerException(e);
    }

    private String message(ClientResponse response) {
        InputStreamReader reader = new InputStreamReader(response.getEntityInputStream(), StandardCharsets.UTF_8);
        try {
            return CharStreams.toString((Readable)reader);
        }
        catch (IOException ignore) {
            return null;
        }
    }

    private MultivaluedMap<String, String> multivaluedMap(Multimap<String, String> map) {
        MultivaluedMapImpl multivaluedMap = new MultivaluedMapImpl();
        for (Map.Entry e : map.entries()) {
            String value = (String)e.getValue();
            if (value == null) continue;
            multivaluedMap.add(e.getKey(), (Object)value);
        }
        return multivaluedMap;
    }

    public static interface ExceptionPropagator {
        public void propagate(UniformInterfaceException var1) throws DockerException;
    }
}

