/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.google.common.base.Throwables;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.ImageNotFoundException;
import com.spotify.docker.client.ImagePullFailedException;
import com.spotify.docker.client.ObjectMapperProvider;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImagePull
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ImagePull.class);
    private final InputStream stream;
    private volatile boolean closed;

    ImagePull(InputStream stream) {
        this.stream = stream;
    }

    void tail(String image) throws DockerException {
        try {
            JsonParser parser = ObjectMapperProvider.objectMapper().getFactory().createParser(this.stream);
            MappingIterator iterator = ObjectMapperProvider.objectMapper().readValues(parser, JsonNode.class);
            while (iterator.hasNextValue()) {
                JsonNode message = (JsonNode)iterator.nextValue();
                JsonNode error = message.get("error");
                if (error != null) {
                    if (error.toString().contains("404")) {
                        throw new ImageNotFoundException(image, message.toString());
                    }
                    throw new ImagePullFailedException(image, message.toString());
                }
                log.info("pull {}: {}", (Object)image, (Object)message);
            }
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            log.warn(this + " not closed properly");
            this.close();
        }
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            this.stream.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

