/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerExit;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.docker.client.messages.RemovedImage;
import com.spotify.docker.client.messages.Version;
import java.util.List;

public interface DockerClient {
    public Version version() throws DockerException, InterruptedException;

    public List<Container> listContainers(ListContainersParam ... var1) throws DockerException, InterruptedException;

    public ContainerInfo inspectContainer(String var1) throws DockerException, InterruptedException;

    public ImageInfo inspectImage(String var1) throws DockerException, InterruptedException;

    public List<RemovedImage> removeImage(String var1) throws DockerException, InterruptedException;

    public List<RemovedImage> removeImage(String var1, boolean var2, boolean var3) throws DockerException, InterruptedException;

    public void pull(String var1) throws DockerException, InterruptedException;

    public void pull(String var1, ProgressHandler var2) throws DockerException, InterruptedException;

    public void push(String var1) throws DockerException, InterruptedException;

    public void push(String var1, ProgressHandler var2) throws DockerException, InterruptedException;

    public void tag(String var1, String var2) throws DockerException, InterruptedException;

    public ContainerCreation createContainer(ContainerConfig var1) throws DockerException, InterruptedException;

    public ContainerCreation createContainer(ContainerConfig var1, String var2) throws DockerException, InterruptedException;

    public void startContainer(String var1) throws DockerException, InterruptedException;

    public void startContainer(String var1, HostConfig var2) throws DockerException, InterruptedException;

    public ContainerExit waitContainer(String var1) throws DockerException, InterruptedException;

    public void killContainer(String var1) throws DockerException, InterruptedException;

    public void removeContainer(String var1) throws DockerException, InterruptedException;

    public void removeContainer(String var1, boolean var2) throws DockerException, InterruptedException;

    public LogStream logs(String var1, LogsParameter ... var2) throws DockerException, InterruptedException;

    public static class ListContainersParam {
        private final String name;
        private final String value;

        public ListContainersParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public static ListContainersParam allContainers() {
            return ListContainersParam.allContainers(true);
        }

        public static ListContainersParam allContainers(boolean all) {
            return ListContainersParam.create("all", String.valueOf(all));
        }

        public static ListContainersParam limitContainers(Integer limit) {
            return ListContainersParam.create("limit", String.valueOf(limit));
        }

        public static ListContainersParam containersCreatedSince(String id) {
            return ListContainersParam.create("since", String.valueOf(id));
        }

        public static ListContainersParam containersCreatedBefore(String id) {
            return ListContainersParam.create("before", String.valueOf(id));
        }

        public static ListContainersParam withContainerSizes(Boolean size) {
            return ListContainersParam.create("size", String.valueOf(size));
        }

        public static ListContainersParam create(String name, String value) {
            return new ListContainersParam(name, value);
        }
    }

    public static enum LogsParameter {
        FOLLOW,
        STDOUT,
        STDERR,
        TIMESTAMPS;

    }
}

