/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.MappingIterator;
import com.google.common.base.Throwables;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.ObjectMapperProvider;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.messages.ProgressMessage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProgressStream
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ProgressStream.class);
    private final InputStream stream;
    private final MappingIterator<ProgressMessage> iterator;
    private volatile boolean closed;

    ProgressStream(InputStream stream) throws IOException {
        this.stream = stream;
        JsonParser parser = ObjectMapperProvider.objectMapper().getFactory().createParser(stream);
        this.iterator = ObjectMapperProvider.objectMapper().readValues(parser, ProgressMessage.class);
    }

    public boolean hasNextMessage() throws DockerException {
        try {
            return this.iterator.hasNextValue();
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    public ProgressMessage nextMessage() throws DockerException {
        try {
            return (ProgressMessage)this.iterator.nextValue();
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    public void tail(ProgressHandler handler) throws DockerException {
        while (this.hasNextMessage()) {
            handler.progress(this.nextMessage());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            log.warn(this + " not closed properly");
            this.close();
        }
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            this.stream.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

