/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ContainerConfig {
    @JsonProperty(value="Hostname")
    private String hostname;
    @JsonProperty(value="Domainname")
    private String domainname;
    @JsonProperty(value="User")
    private String user;
    @JsonProperty(value="Memory")
    private Long memory;
    @JsonProperty(value="MemorySwap")
    private Long memorySwap;
    @JsonProperty(value="CpuShares")
    private Long cpuShares;
    @JsonProperty(value="Cpuset")
    private String cpuset;
    @JsonProperty(value="AttachStdin")
    private Boolean attachStdin;
    @JsonProperty(value="AttachStdout")
    private Boolean attachStdout;
    @JsonProperty(value="AttachStderr")
    private Boolean attachStderr;
    @JsonProperty(value="PortSpecs")
    private ImmutableList<String> portSpecs;
    @JsonProperty(value="ExposedPorts")
    private ImmutableSet<String> exposedPorts;
    @JsonProperty(value="Tty")
    private Boolean tty;
    @JsonProperty(value="OpenStdin")
    private Boolean openStdin;
    @JsonProperty(value="StdinOnce")
    private Boolean stdinOnce;
    @JsonProperty(value="Env")
    private ImmutableList<String> env;
    @JsonProperty(value="Cmd")
    private ImmutableList<String> cmd;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="Volumes")
    private ImmutableSet<String> volumes;
    @JsonProperty(value="WorkingDir")
    private String workingDir;
    @JsonProperty(value="Entrypoint")
    private ImmutableList<String> entrypoint;
    @JsonProperty(value="NetworkDisabled")
    private Boolean networkDisabled;
    @JsonProperty(value="OnBuild")
    private ImmutableList<String> onBuild;

    private ContainerConfig() {
    }

    private ContainerConfig(Builder builder) {
        this.hostname = builder.hostname;
        this.domainname = builder.domainname;
        this.user = builder.user;
        this.memory = builder.memory;
        this.memorySwap = builder.memorySwap;
        this.cpuShares = builder.cpuShares;
        this.cpuset = builder.cpuset;
        this.attachStdin = builder.attachStdin;
        this.attachStdout = builder.attachStdout;
        this.attachStderr = builder.attachStderr;
        this.portSpecs = builder.portSpecs;
        this.exposedPorts = builder.exposedPorts;
        this.tty = builder.tty;
        this.openStdin = builder.openStdin;
        this.stdinOnce = builder.stdinOnce;
        this.env = builder.env;
        this.cmd = builder.cmd;
        this.image = builder.image;
        this.volumes = builder.volumes;
        this.workingDir = builder.workingDir;
        this.entrypoint = builder.entrypoint;
        this.networkDisabled = builder.networkDisabled;
        this.onBuild = builder.onBuild;
    }

    public String hostname() {
        return this.hostname;
    }

    public String domainname() {
        return this.domainname;
    }

    public String user() {
        return this.user;
    }

    public Long memory() {
        return this.memory;
    }

    public Long memorySwap() {
        return this.memorySwap;
    }

    public Long cpuShares() {
        return this.cpuShares;
    }

    public String cpuset() {
        return this.cpuset;
    }

    public Boolean attachStdin() {
        return this.attachStdin;
    }

    public Boolean attachStdout() {
        return this.attachStdout;
    }

    public Boolean attachStderr() {
        return this.attachStderr;
    }

    public List<String> portSpecs() {
        return this.portSpecs;
    }

    public Set<String> exposedPorts() {
        return this.exposedPorts;
    }

    public Boolean tty() {
        return this.tty;
    }

    public Boolean openStdin() {
        return this.openStdin;
    }

    public Boolean stdinOnce() {
        return this.stdinOnce;
    }

    public List<String> env() {
        return this.env;
    }

    public List<String> cmd() {
        return this.cmd;
    }

    public String image() {
        return this.image;
    }

    public Set<String> volumes() {
        return this.volumes;
    }

    public String workingDir() {
        return this.workingDir;
    }

    public List<String> entrypoint() {
        return this.entrypoint;
    }

    public Boolean networkDisabled() {
        return this.networkDisabled;
    }

    public List<String> onBuild() {
        return this.onBuild;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerConfig config = (ContainerConfig)o;
        if (this.attachStderr != null ? !this.attachStderr.equals(config.attachStderr) : config.attachStderr != null) {
            return false;
        }
        if (this.attachStdin != null ? !this.attachStdin.equals(config.attachStdin) : config.attachStdin != null) {
            return false;
        }
        if (this.attachStdout != null ? !this.attachStdout.equals(config.attachStdout) : config.attachStdout != null) {
            return false;
        }
        if (this.cmd != null ? !this.cmd.equals(config.cmd) : config.cmd != null) {
            return false;
        }
        if (this.cpuShares != null ? !this.cpuShares.equals(config.cpuShares) : config.cpuShares != null) {
            return false;
        }
        if (this.cpuset != null ? !this.cpuset.equals(config.cpuset) : config.cpuset != null) {
            return false;
        }
        if (this.domainname != null ? !this.domainname.equals(config.domainname) : config.domainname != null) {
            return false;
        }
        if (this.entrypoint != null ? !this.entrypoint.equals(config.entrypoint) : config.entrypoint != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(config.env) : config.env != null) {
            return false;
        }
        if (this.exposedPorts != null ? !this.exposedPorts.equals(config.exposedPorts) : config.exposedPorts != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(config.hostname) : config.hostname != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(config.image) : config.image != null) {
            return false;
        }
        if (this.memory != null ? !this.memory.equals(config.memory) : config.memory != null) {
            return false;
        }
        if (this.memorySwap != null ? !this.memorySwap.equals(config.memorySwap) : config.memorySwap != null) {
            return false;
        }
        if (this.networkDisabled != null ? !this.networkDisabled.equals(config.networkDisabled) : config.networkDisabled != null) {
            return false;
        }
        if (this.onBuild != null ? !this.onBuild.equals(config.onBuild) : config.onBuild != null) {
            return false;
        }
        if (this.openStdin != null ? !this.openStdin.equals(config.openStdin) : config.openStdin != null) {
            return false;
        }
        if (this.portSpecs != null ? !this.portSpecs.equals(config.portSpecs) : config.portSpecs != null) {
            return false;
        }
        if (this.stdinOnce != null ? !this.stdinOnce.equals(config.stdinOnce) : config.stdinOnce != null) {
            return false;
        }
        if (this.tty != null ? !this.tty.equals(config.tty) : config.tty != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(config.user) : config.user != null) {
            return false;
        }
        if (this.volumes != null ? !this.volumes.equals(config.volumes) : config.volumes != null) {
            return false;
        }
        return !(this.workingDir != null ? !this.workingDir.equals(config.workingDir) : config.workingDir != null);
    }

    public int hashCode() {
        int result = this.hostname != null ? this.hostname.hashCode() : 0;
        result = 31 * result + (this.domainname != null ? this.domainname.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
        result = 31 * result + (this.memorySwap != null ? this.memorySwap.hashCode() : 0);
        result = 31 * result + (this.cpuShares != null ? this.cpuShares.hashCode() : 0);
        result = 31 * result + (this.cpuset != null ? this.cpuset.hashCode() : 0);
        result = 31 * result + (this.attachStdin != null ? this.attachStdin.hashCode() : 0);
        result = 31 * result + (this.attachStdout != null ? this.attachStdout.hashCode() : 0);
        result = 31 * result + (this.attachStderr != null ? this.attachStderr.hashCode() : 0);
        result = 31 * result + (this.portSpecs != null ? this.portSpecs.hashCode() : 0);
        result = 31 * result + (this.exposedPorts != null ? this.exposedPorts.hashCode() : 0);
        result = 31 * result + (this.tty != null ? this.tty.hashCode() : 0);
        result = 31 * result + (this.openStdin != null ? this.openStdin.hashCode() : 0);
        result = 31 * result + (this.stdinOnce != null ? this.stdinOnce.hashCode() : 0);
        result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
        result = 31 * result + (this.cmd != null ? this.cmd.hashCode() : 0);
        result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
        result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
        result = 31 * result + (this.workingDir != null ? this.workingDir.hashCode() : 0);
        result = 31 * result + (this.entrypoint != null ? this.entrypoint.hashCode() : 0);
        result = 31 * result + (this.networkDisabled != null ? this.networkDisabled.hashCode() : 0);
        result = 31 * result + (this.onBuild != null ? this.onBuild.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("hostname", (Object)this.hostname).add("domainname", (Object)this.domainname).add("user", (Object)this.user).add("memory", (Object)this.memory).add("memorySwap", (Object)this.memorySwap).add("cpuShares", (Object)this.cpuShares).add("cpuset", (Object)this.cpuset).add("attachStdin", (Object)this.attachStdin).add("attachStdout", (Object)this.attachStdout).add("attachStderr", (Object)this.attachStderr).add("portSpecs", this.portSpecs).add("exposedPorts", this.exposedPorts).add("tty", (Object)this.tty).add("openStdin", (Object)this.openStdin).add("stdinOnce", (Object)this.stdinOnce).add("env", this.env).add("cmd", this.cmd).add("image", (Object)this.image).add("volumes", this.volumes).add("workingDir", (Object)this.workingDir).add("entrypoint", this.entrypoint).add("networkDisabled", (Object)this.networkDisabled).add("onBuild", this.onBuild).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String hostname;
        private String domainname;
        private String user;
        private Long memory;
        private Long memorySwap;
        private Long cpuShares;
        private String cpuset;
        private Boolean attachStdin;
        private Boolean attachStdout;
        private Boolean attachStderr;
        private ImmutableList<String> portSpecs;
        private ImmutableSet<String> exposedPorts;
        private Boolean tty;
        private Boolean openStdin;
        private Boolean stdinOnce;
        private ImmutableList<String> env;
        private ImmutableList<String> cmd;
        private String image;
        private ImmutableSet<String> volumes;
        private String workingDir;
        private ImmutableList<String> entrypoint;
        private Boolean networkDisabled;
        private ImmutableList<String> onBuild;

        private Builder() {
        }

        private Builder(ContainerConfig config) {
            this.hostname = config.hostname;
            this.domainname = config.domainname;
            this.user = config.user;
            this.memory = config.memory;
            this.memorySwap = config.memorySwap;
            this.cpuShares = config.cpuShares;
            this.cpuset = config.cpuset;
            this.attachStdin = config.attachStdin;
            this.attachStdout = config.attachStdout;
            this.attachStderr = config.attachStderr;
            this.portSpecs = config.portSpecs;
            this.exposedPorts = config.exposedPorts;
            this.tty = config.tty;
            this.openStdin = config.openStdin;
            this.stdinOnce = config.stdinOnce;
            this.env = config.env;
            this.cmd = config.cmd;
            this.image = config.image;
            this.volumes = config.volumes;
            this.workingDir = config.workingDir;
            this.entrypoint = config.entrypoint;
            this.networkDisabled = config.networkDisabled;
            this.onBuild = config.onBuild;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public String hostname() {
            return this.hostname;
        }

        public Builder domainname(String domainname) {
            this.domainname = domainname;
            return this;
        }

        public String domainname() {
            return this.domainname;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public String user() {
            return this.user;
        }

        public Builder memory(Long memory) {
            this.memory = memory;
            return this;
        }

        public Long memory() {
            return this.memory;
        }

        public Builder memorySwap(Long memorySwap) {
            this.memorySwap = memorySwap;
            return this;
        }

        public Long memorySwap() {
            return this.memorySwap;
        }

        public Builder cpuShares(Long cpuShares) {
            this.cpuShares = cpuShares;
            return this;
        }

        public Long cpuShares() {
            return this.cpuShares;
        }

        public Builder cpuset(String cpuset) {
            this.cpuset = cpuset;
            return this;
        }

        public String cpuset() {
            return this.cpuset;
        }

        public Builder attachStdin(Boolean attachStdin) {
            this.attachStdin = attachStdin;
            return this;
        }

        public Boolean attachStdin() {
            return this.attachStdin;
        }

        public Builder attachStdout(Boolean attachStdout) {
            this.attachStdout = attachStdout;
            return this;
        }

        public Boolean attachStdout() {
            return this.attachStdout;
        }

        public Builder attachStderr(Boolean attachStderr) {
            this.attachStderr = attachStderr;
            return this;
        }

        public Boolean attachStderr() {
            return this.attachStderr;
        }

        public Builder portSpecs(List<String> portSpecs) {
            this.portSpecs = ImmutableList.copyOf(portSpecs);
            return this;
        }

        public Builder portSpecs(String ... portSpecs) {
            this.portSpecs = ImmutableList.copyOf((Object[])portSpecs);
            return this;
        }

        public List<String> portSpecs() {
            return this.portSpecs;
        }

        public Builder exposedPorts(Set<String> exposedPorts) {
            this.exposedPorts = ImmutableSet.copyOf(exposedPorts);
            return this;
        }

        public Builder exposedPorts(String ... exposedPorts) {
            this.exposedPorts = ImmutableSet.copyOf((Object[])exposedPorts);
            return this;
        }

        public Set<String> exposedPorts() {
            return this.exposedPorts;
        }

        public Builder tty(Boolean tty) {
            this.tty = tty;
            return this;
        }

        public Boolean tty() {
            return this.tty;
        }

        public Builder openStdin(Boolean openStdin) {
            this.openStdin = openStdin;
            return this;
        }

        public Boolean openStdin() {
            return this.openStdin;
        }

        public Builder stdinOnce(Boolean stdinOnce) {
            this.stdinOnce = stdinOnce;
            return this;
        }

        public Boolean stdinOnce() {
            return this.stdinOnce;
        }

        public Builder env(List<String> env) {
            this.env = ImmutableList.copyOf(env);
            return this;
        }

        public Builder env(String ... env) {
            this.env = ImmutableList.copyOf((Object[])env);
            return this;
        }

        public List<String> env() {
            return this.env;
        }

        public Builder cmd(List<String> cmd) {
            this.cmd = ImmutableList.copyOf(cmd);
            return this;
        }

        public Builder cmd(String ... cmd) {
            this.cmd = ImmutableList.copyOf((Object[])cmd);
            return this;
        }

        public List<String> cmd() {
            return this.cmd;
        }

        public Builder image(String image) {
            this.image = image;
            return this;
        }

        public String image() {
            return this.image;
        }

        public Builder volumes(Set<String> volumes) {
            this.volumes = ImmutableSet.copyOf(volumes);
            return this;
        }

        public Builder volumes(String ... volumes) {
            this.volumes = ImmutableSet.copyOf((Object[])volumes);
            return this;
        }

        public Set<String> volumes() {
            return this.volumes;
        }

        public Builder workingDir(String workingDir) {
            this.workingDir = workingDir;
            return this;
        }

        public String workingDir() {
            return this.workingDir;
        }

        public Builder entrypoint(List<String> entrypoint) {
            this.entrypoint = ImmutableList.copyOf(entrypoint);
            return this;
        }

        public Builder entrypoint(String ... entrypoint) {
            this.entrypoint = ImmutableList.copyOf((Object[])entrypoint);
            return this;
        }

        public List<String> entrypoint() {
            return this.entrypoint;
        }

        public Builder networkDisabled(Boolean networkDisabled) {
            this.networkDisabled = networkDisabled;
            return this;
        }

        public Boolean networkDisabled() {
            return this.networkDisabled;
        }

        public Builder onBuild(List<String> onBuild) {
            this.onBuild = ImmutableList.copyOf(onBuild);
            return this;
        }

        public Builder onBuild(String ... onBuild) {
            this.onBuild = ImmutableList.copyOf((Object[])onBuild);
            return this;
        }

        public List<String> onBuild() {
            return this.onBuild;
        }

        public ContainerConfig build() {
            return new ContainerConfig(this);
        }
    }
}

