/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.TerminatingClientHandler;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class InterruptibleURLConnectionClientHandler
extends TerminatingClientHandler {
    private final ExecutorService executor = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newCachedThreadPool()), (long)0L, (TimeUnit)TimeUnit.SECONDS);

    InterruptibleURLConnectionClientHandler() {
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        RequestTask request = new RequestTask(cr);
        Future<ClientResponse> future = this.executor.submit(request);
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            request.close();
            throw new ClientHandlerException((Throwable)new InterruptedIOException(e.toString()));
        }
        catch (ExecutionException e) {
            request.close();
            Throwable cause = e.getCause() == null ? e : e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)cause, ClientHandlerException.class);
            throw new ClientHandlerException(cause);
        }
    }

    private class RequestTask
    implements Callable<ClientResponse>,
    HttpURLConnectionFactory {
        private final List<HttpURLConnection> connections = Lists.newCopyOnWriteArrayList();
        private final ClientRequest cr;

        public RequestTask(ClientRequest cr) {
            this.cr = cr;
        }

        @Override
        public ClientResponse call() throws Exception {
            URLConnectionClientHandler handler = new URLConnectionClientHandler((HttpURLConnectionFactory)this);
            handler.setMessageBodyWorkers(InterruptibleURLConnectionClientHandler.this.getMessageBodyWorkers());
            return handler.handle(this.cr);
        }

        public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            this.connections.add(connection);
            return connection;
        }

        public void close() {
            for (HttpURLConnection connection : this.connections) {
                connection.disconnect();
            }
        }
    }
}

