/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.spotify.docker.client.CompressedDirectory;
import com.spotify.docker.client.ContainerNotFoundException;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.DockerRequestException;
import com.spotify.docker.client.DockerTimeoutException;
import com.spotify.docker.client.ImageNotFoundException;
import com.spotify.docker.client.ImageRef;
import com.spotify.docker.client.InterruptibleApacheClientHandler;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.LoggingBuildHandler;
import com.spotify.docker.client.LoggingPullHandler;
import com.spotify.docker.client.LoggingPushHandler;
import com.spotify.docker.client.LogsResponseReader;
import com.spotify.docker.client.ObjectMapperProvider;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.ProgressResponseReader;
import com.spotify.docker.client.ProgressStream;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerExit;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.Image;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.docker.client.messages.Info;
import com.spotify.docker.client.messages.ProgressMessage;
import com.spotify.docker.client.messages.RemovedImage;
import com.spotify.docker.client.messages.Version;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.TerminatingClientHandler;
import com.sun.jersey.api.client.UniformInterface;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.http.conn.ConnectTimeoutException;

public class DefaultDockerClient
implements DockerClient,
Closeable {
    public static final long NO_TIMEOUT = 0L;
    private static final long DEFAULT_CONNECT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    private static final long DEFAULT_READ_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private static final String VERSION = "v1.12";
    private static final DefaultClientConfig CLIENT_CONFIG = new DefaultClientConfig(new Class[]{ObjectMapperProvider.class, LogsResponseReader.class, ProgressResponseReader.class});
    private static final Pattern CONTAINER_NAME_PATTERN = Pattern.compile("/?[a-zA-Z0-9_-]+");
    private static final GenericType<List<Container>> CONTAINER_LIST = new GenericType<List<Container>>(){};
    private static final GenericType<List<Image>> IMAGE_LIST = new GenericType<List<Image>>(){};
    private static final GenericType<List<RemovedImage>> REMOVED_IMAGE_LIST = new GenericType<List<RemovedImage>>(){};
    private static final AtomicInteger CLIENT_COUNTER = new AtomicInteger();
    private static final URI UNIX_SOCKET_URI = URI.create("unix://localhost");
    private final ExecutorService executor = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("docker-client-" + CLIENT_COUNTER.incrementAndGet() + "-%d").build())));
    private final TerminatingClientHandler clientHandler;
    private final Client client;
    private final URI uri;

    public DefaultDockerClient(String uri) {
        this(URI.create(uri));
    }

    public DefaultDockerClient(URI uri) {
        URI originalUri = (URI)Preconditions.checkNotNull((Object)uri, (Object)"uri");
        this.clientHandler = new InterruptibleApacheClientHandler(originalUri, this.executor);
        this.client = new Client((ClientHandler)this.clientHandler, (ClientConfig)CLIENT_CONFIG);
        this.client.setConnectTimeout(Integer.valueOf((int)DEFAULT_CONNECT_TIMEOUT_MILLIS));
        this.client.setReadTimeout(Integer.valueOf((int)DEFAULT_READ_TIMEOUT_MILLIS));
        this.uri = originalUri.getScheme().equals("unix") ? UNIX_SOCKET_URI : originalUri;
    }

    private DefaultDockerClient(Builder builder) {
        URI originalUri = (URI)Preconditions.checkNotNull((Object)builder.uri, (Object)"uri");
        this.clientHandler = new InterruptibleApacheClientHandler(originalUri, this.executor);
        this.client = new Client((ClientHandler)this.clientHandler, (ClientConfig)CLIENT_CONFIG);
        this.client.setConnectTimeout(Integer.valueOf((int)builder.connectTimeoutMillis));
        this.client.setReadTimeout(Integer.valueOf((int)builder.readTimeoutMillis));
        this.uri = originalUri.getScheme().equals("unix") ? UNIX_SOCKET_URI : originalUri;
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
        this.client.destroy();
    }

    @Override
    public String ping() throws DockerException, InterruptedException {
        WebResource resource = this.client.resource(this.uri).path("_ping");
        return this.request("GET", String.class, resource, (UniformInterface)resource);
    }

    @Override
    public Version version() throws DockerException, InterruptedException {
        WebResource resource = this.resource().path("version");
        return this.request("GET", Version.class, resource, (UniformInterface)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public Info info() throws DockerException, InterruptedException {
        WebResource resource = this.resource().path("info");
        return this.request("GET", Info.class, resource, (UniformInterface)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public List<Container> listContainers(DockerClient.ListContainersParam ... params) throws DockerException, InterruptedException {
        ArrayListMultimap paramMap = ArrayListMultimap.create();
        for (DockerClient.ListContainersParam param : params) {
            paramMap.put((Object)param.name(), (Object)param.value());
        }
        WebResource resource = this.resource().path("containers").path("json").queryParams(this.multivaluedMap((Multimap<String, String>)paramMap));
        return this.request("GET", CONTAINER_LIST, resource, resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public List<Image> listImages(DockerClient.ListImagesParam ... params) throws DockerException, InterruptedException {
        MultivaluedMapImpl paramMap = new MultivaluedMapImpl();
        HashMap filters = Maps.newHashMap();
        for (DockerClient.ListImagesParam param : params) {
            if (param instanceof DockerClient.ListImagesFilterParam) {
                filters.put(param.name(), param.value());
                continue;
            }
            paramMap.putSingle((Object)param.name(), (Object)param.value());
        }
        try {
            if (!filters.isEmpty()) {
                StringWriter writer = new StringWriter();
                JsonGenerator generator = ObjectMapperProvider.objectMapper().getFactory().createGenerator((Writer)writer);
                generator.writeStartObject();
                for (Map.Entry entry : filters.entrySet()) {
                    generator.writeArrayFieldStart((String)entry.getKey());
                    generator.writeString((String)entry.getValue());
                    generator.writeEndArray();
                }
                generator.writeEndObject();
                generator.close();
                String encoded = URLEncoder.encode(writer.toString(), StandardCharsets.UTF_8.name());
                paramMap.putSingle((Object)"filters", (Object)encoded);
            }
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
        WebResource resource = this.resource().path("images").path("json").queryParams((MultivaluedMap)paramMap);
        return this.request("GET", IMAGE_LIST, resource, resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public ContainerCreation createContainer(ContainerConfig config) throws DockerException, InterruptedException {
        return this.createContainer(config, null);
    }

    @Override
    public ContainerCreation createContainer(ContainerConfig config, String name) throws DockerException, InterruptedException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (name != null) {
            Preconditions.checkArgument((boolean)CONTAINER_NAME_PATTERN.matcher(name).matches(), (String)"Invalid container name: \"%s\"", (Object[])new Object[]{name});
            params.add((Object)"name", (Object)name);
        }
        try {
            WebResource resource = this.resource().path("containers").path("create").queryParams((MultivaluedMap)params);
            return this.request("POST", ContainerCreation.class, resource, (UniformInterface)((WebResource.Builder)resource.entity((Object)config).type(MediaType.APPLICATION_JSON_TYPE)).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(config.image(), e);
                }
            }
            throw e;
        }
    }

    @Override
    public void startContainer(String containerId) throws DockerException, InterruptedException {
        this.startContainer(containerId, HostConfig.builder().build());
    }

    @Override
    public void startContainer(String containerId, HostConfig hostConfig) throws DockerException, InterruptedException {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId");
        Preconditions.checkNotNull((Object)hostConfig, (Object)"hostConfig");
        try {
            WebResource resource = this.resource().path("containers").path(containerId).path("start");
            this.request("POST", resource, (UniformInterface)((WebResource.Builder)resource.type(MediaType.APPLICATION_JSON_TYPE).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).entity((Object)hostConfig));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void restartContainer(String containerId) throws DockerException, InterruptedException {
        this.restartContainer(containerId, 10);
    }

    @Override
    public void restartContainer(String containerId, int secondsToWaitBeforeRestart) throws DockerException, InterruptedException {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId");
        Preconditions.checkNotNull((Object)secondsToWaitBeforeRestart, (Object)"secondsToWait");
        try {
            WebResource resource = this.resource().path("containers").path(containerId).path("restart");
            this.request("POST", resource, (UniformInterface)resource.queryParam("t", String.valueOf(secondsToWaitBeforeRestart)));
        }
        catch (UniformInterfaceException e) {
            switch (e.getResponse().getStatus()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw new DockerException(e);
        }
    }

    @Override
    public void killContainer(String containerId) throws DockerException, InterruptedException {
        try {
            WebResource resource = this.resource().path("containers").path(containerId).path("kill");
            this.request("POST", resource, (UniformInterface)resource);
        }
        catch (UniformInterfaceException e) {
            switch (e.getResponse().getStatus()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw new DockerException(e);
        }
    }

    @Override
    public void stopContainer(String containerId, int secondsToWaitBeforeKilling) throws DockerException, InterruptedException {
        try {
            WebResource resource = this.resource().path("containers").path(containerId).path("stop");
            this.request("POST", resource, (UniformInterface)resource.queryParam("t", String.valueOf(secondsToWaitBeforeKilling)));
        }
        catch (UniformInterfaceException e) {
            switch (e.getResponse().getStatus()) {
                case 304: {
                    return;
                }
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw new DockerException(e);
        }
    }

    @Override
    public ContainerExit waitContainer(String containerId) throws DockerException, InterruptedException {
        try {
            WebResource resource = this.resource().path("containers").path(containerId).path("wait");
            resource.setProperty("com.sun.jersey.client.property.readTimeout", (Object)0);
            return this.request("POST", ContainerExit.class, resource, (UniformInterface)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void removeContainer(String containerId) throws DockerException, InterruptedException {
        this.removeContainer(containerId, false);
    }

    @Override
    public void removeContainer(String containerId, boolean removeVolumes) throws DockerException, InterruptedException {
        try {
            WebResource resource = this.resource().path("containers").path(containerId);
            this.request("DELETE", resource, (UniformInterface)resource.queryParam("v", String.valueOf(removeVolumes)).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (UniformInterfaceException e) {
            switch (e.getResponse().getStatus()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId);
                }
            }
            throw new DockerException(e);
        }
    }

    @Override
    public InputStream exportContainer(String containerId) throws DockerException, InterruptedException {
        WebResource resource = this.resource().path("containers").path(containerId).path("export");
        return this.request("GET", InputStream.class, resource, (UniformInterface)resource.accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}));
    }

    @Override
    public InputStream copyContainer(String containerId, String path) throws DockerException, InterruptedException {
        WebResource resource = this.resource().path("containers").path(containerId).path("copy");
        JsonNodeFactory nf = JsonNodeFactory.instance;
        JsonNode params = nf.objectNode().set("Resource", (JsonNode)nf.textNode(path));
        return this.request("POST", InputStream.class, resource, (UniformInterface)resource.accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).entity((Object)params, MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public ContainerInfo inspectContainer(String containerId) throws DockerException, InterruptedException {
        try {
            WebResource resource = this.resource().path("containers").path(containerId).path("json");
            return this.request("GET", ContainerInfo.class, resource, (UniformInterface)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void pull(String image) throws DockerException, InterruptedException {
        this.pull(image, new LoggingPullHandler(image));
    }

    @Override
    public void pull(String image, ProgressHandler handler) throws DockerException, InterruptedException {
        ImageRef imageRef = new ImageRef(image);
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"fromImage", (Object)imageRef.getImage());
        if (imageRef.getTag() != null) {
            params.add((Object)"tag", (Object)imageRef.getTag());
        }
        WebResource resource = this.resource().path("images").path("create").queryParams((MultivaluedMap)params);
        try (ProgressStream pull = this.request("POST", ProgressStream.class, resource, (UniformInterface)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));){
            pull.tail(handler, "POST", resource.getURI());
        }
    }

    @Override
    public void push(String image) throws DockerException, InterruptedException {
        this.push(image, new LoggingPushHandler(image));
    }

    @Override
    public void push(String image, ProgressHandler handler) throws DockerException, InterruptedException {
        ImageRef imageRef = new ImageRef(image);
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (imageRef.getTag() != null) {
            params.add((Object)"tag", (Object)imageRef.getTag());
        }
        WebResource resource = this.resource().path("images").path(imageRef.getImage()).path("push").queryParams((MultivaluedMap)params);
        try (ProgressStream push = this.request("POST", ProgressStream.class, resource, (UniformInterface)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Registry-Auth", (Object)"null"));){
            push.tail(handler, "POST", resource.getURI());
        }
    }

    @Override
    public void tag(String image, String name) throws DockerException, InterruptedException {
        ImageRef imageRef = new ImageRef(name);
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"repo", (Object)imageRef.getImage());
        if (imageRef.getTag() != null) {
            params.add((Object)"tag", (Object)imageRef.getTag());
        }
        WebResource resource = this.resource().path("images").path(image).path("tag").queryParams((MultivaluedMap)params);
        try {
            this.request("POST", resource, (UniformInterface)resource);
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(image, e);
                }
            }
            throw e;
        }
    }

    @Override
    public String build(Path directory, DockerClient.BuildParameter ... params) throws DockerException, InterruptedException, IOException {
        return this.build(directory, null, new LoggingBuildHandler(), params);
    }

    @Override
    public String build(Path directory, String name, DockerClient.BuildParameter ... params) throws DockerException, InterruptedException, IOException {
        return this.build(directory, name, new LoggingBuildHandler(), params);
    }

    @Override
    public String build(Path directory, ProgressHandler handler, DockerClient.BuildParameter ... params) throws DockerException, InterruptedException, IOException {
        return this.build(directory, null, handler, params);
    }

    /*
     * Loose catch block
     */
    @Override
    public String build(Path directory, String name, ProgressHandler handler, DockerClient.BuildParameter ... params) throws DockerException, InterruptedException, IOException {
        Preconditions.checkNotNull((Object)handler, (Object)"handler");
        ArrayListMultimap paramMap = ArrayListMultimap.create();
        for (DockerClient.BuildParameter param : params) {
            paramMap.put((Object)param.queryParam, (Object)String.valueOf(param.value));
        }
        if (name != null) {
            paramMap.put((Object)"t", (Object)name);
        }
        WebResource resource = this.resource().path("build").queryParams(this.multivaluedMap((Multimap<String, String>)paramMap));
        File compressedDirectory = CompressedDirectory.create(directory);
        try {
            try (ProgressStream build = this.request("POST", ProgressStream.class, resource, (UniformInterface)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).entity((Object)compressedDirectory, "application/tar"));){
                String imageId = null;
                while (build.hasNextMessage("POST", resource.getURI())) {
                    ProgressMessage message = build.nextMessage("POST", resource.getURI());
                    String id = message.buildImageId();
                    if (id != null) {
                        imageId = id;
                    }
                    handler.progress(message);
                }
                String string = imageId;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            CompressedDirectory.delete(compressedDirectory);
        }
    }

    @Override
    public ImageInfo inspectImage(String image) throws DockerException, InterruptedException {
        try {
            WebResource resource = this.resource().path("images").path(image).path("json");
            return this.request("GET", ImageInfo.class, resource, (UniformInterface)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(image, e);
                }
            }
            throw e;
        }
    }

    @Override
    public List<RemovedImage> removeImage(String image) throws DockerException, InterruptedException {
        return this.removeImage(image, false, false);
    }

    @Override
    public List<RemovedImage> removeImage(String image, boolean force, boolean noPrune) throws DockerException, InterruptedException {
        try {
            WebResource resource = this.resource().path("images").path(image).queryParam("force", String.valueOf(force)).queryParam("noprune", String.valueOf(noPrune));
            return this.request("DELETE", REMOVED_IMAGE_LIST, resource, resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (UniformInterfaceException e) {
            switch (e.getResponse().getStatus()) {
                case 404: {
                    throw new ImageNotFoundException(image);
                }
            }
            throw new DockerException(e);
        }
    }

    @Override
    public LogStream logs(String containerId, DockerClient.LogsParameter ... params) throws DockerException, InterruptedException {
        ArrayListMultimap paramMap = ArrayListMultimap.create();
        for (DockerClient.LogsParameter param : params) {
            paramMap.put((Object)param.name().toLowerCase(Locale.ROOT), (Object)String.valueOf(true));
        }
        WebResource resource = this.resource().path("containers").path(containerId).path("logs").queryParams(this.multivaluedMap((Multimap<String, String>)paramMap));
        try {
            return this.request("GET", LogStream.class, resource, (UniformInterface)resource.accept(new String[]{"application/vnd.docker.raw-stream"}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId);
                }
            }
            throw e;
        }
    }

    private WebResource resource() {
        return this.client.resource(this.uri).path(VERSION);
    }

    private <T> T request(String method, GenericType<T> type, WebResource resource, WebResource.Builder request) throws DockerException, InterruptedException {
        try {
            return (T)request.method(method, type);
        }
        catch (ClientHandlerException e) {
            throw this.propagate(method, resource, e);
        }
        catch (UniformInterfaceException e) {
            throw this.propagate(method, resource, e);
        }
    }

    private <T> T request(String method, Class<T> clazz, WebResource resource, UniformInterface request) throws DockerException, InterruptedException {
        try {
            return (T)request.method(method, clazz);
        }
        catch (ClientHandlerException e) {
            throw this.propagate(method, resource, e);
        }
        catch (UniformInterfaceException e) {
            throw this.propagate(method, resource, e);
        }
    }

    private void request(String method, WebResource resource, UniformInterface request) throws DockerException, InterruptedException {
        try {
            request.method(method);
        }
        catch (ClientHandlerException e) {
            throw this.propagate(method, resource, e);
        }
        catch (UniformInterfaceException e) {
            throw this.propagate(method, resource, e);
        }
    }

    private DockerRequestException propagate(String method, WebResource resource, UniformInterfaceException e) {
        return new DockerRequestException(method, resource.getURI(), e.getResponse().getStatus(), this.message(e.getResponse()), e);
    }

    private RuntimeException propagate(String method, WebResource resource, ClientHandlerException e) throws DockerException, InterruptedException {
        Throwable cause = e.getCause();
        if (cause instanceof SocketTimeoutException || cause instanceof ConnectTimeoutException) {
            throw new DockerTimeoutException(method, resource.getURI(), e);
        }
        if (cause instanceof InterruptedIOException) {
            throw new InterruptedException("Interrupted: " + method + " " + resource);
        }
        throw new DockerException(e);
    }

    private String message(ClientResponse response) {
        InputStreamReader reader = new InputStreamReader(response.getEntityInputStream(), StandardCharsets.UTF_8);
        try {
            return CharStreams.toString((Readable)reader);
        }
        catch (IOException ignore) {
            return null;
        }
    }

    private MultivaluedMap<String, String> multivaluedMap(Multimap<String, String> map) {
        MultivaluedMapImpl multivaluedMap = new MultivaluedMapImpl();
        for (Map.Entry e : map.entries()) {
            String value = (String)e.getValue();
            if (value == null) continue;
            multivaluedMap.add(e.getKey(), (Object)value);
        }
        return multivaluedMap;
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ long access$300() {
        return DEFAULT_CONNECT_TIMEOUT_MILLIS;
    }

    static /* synthetic */ long access$400() {
        return DEFAULT_READ_TIMEOUT_MILLIS;
    }

    public static class Builder {
        private URI uri;
        private long connectTimeoutMillis = DefaultDockerClient.access$300();
        private long readTimeoutMillis = DefaultDockerClient.access$400();

        public URI uri() {
            return this.uri;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder uri(String uri) {
            return this.uri(URI.create(uri));
        }

        public long connectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        public Builder connectTimeoutMillis(long connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        public long readTimeoutMillis() {
            return this.readTimeoutMillis;
        }

        public Builder readTimeoutMillis(long readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public DefaultDockerClient build() {
            return new DefaultDockerClient(this);
        }
    }

    public static interface ExceptionPropagator {
        public void propagate(UniformInterfaceException var1) throws DockerException;
    }
}

