/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.base.Throwables;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.TerminatingClientHandler;
import com.sun.jersey.client.apache4.ApacheHttpClient4Handler;
import de.gesellix.socketfactory.unix.UnixSocketFactory;
import java.io.InterruptedIOException;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;

class InterruptibleApacheClientHandler
extends TerminatingClientHandler {
    private final URI baseUri;
    private final ExecutorService executor;

    InterruptibleApacheClientHandler(URI baseUri, ExecutorService executor) {
        this.baseUri = baseUri;
        this.executor = executor;
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        RequestTask request = new RequestTask(cr);
        Future<ClientResponse> future = this.executor.submit(request);
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            request.close();
            throw new ClientHandlerException((Throwable)new InterruptedIOException(e.toString()));
        }
        catch (ExecutionException e) {
            request.close();
            Throwable cause = e.getCause() == null ? e : e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)cause, ClientHandlerException.class);
            throw new ClientHandlerException(cause);
        }
    }

    private class RequestTask
    implements Callable<ClientResponse> {
        private final DefaultHttpClient httpClient;
        private final ClientRequest cr;

        public RequestTask(ClientRequest cr) {
            this.cr = cr;
            this.httpClient = new DefaultHttpClient();
            this.httpClient.getParams().setIntParameter("http.connection.timeout", ((Integer)cr.getProperties().get("com.sun.jersey.client.property.connectTimeout")).intValue()).setIntParameter("http.socket.timeout", ((Integer)cr.getProperties().get("com.sun.jersey.client.property.readTimeout")).intValue());
            this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
            if (cr.getURI().getScheme().equalsIgnoreCase("unix")) {
                UnixSocketFactory sf = new UnixSocketFactory();
                sf.configure((Object)this.httpClient, (String)sf.sanitize((Object)InterruptibleApacheClientHandler.this.baseUri.toString()));
            }
        }

        @Override
        public ClientResponse call() throws Exception {
            ApacheHttpClient4Handler handler = new ApacheHttpClient4Handler((HttpClient)this.httpClient, null, false);
            handler.setMessageBodyWorkers(InterruptibleApacheClientHandler.this.getMessageBodyWorkers());
            return handler.handle(this.cr);
        }

        public void close() {
            this.httpClient.getConnectionManager().shutdown();
        }
    }
}

