/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.spotify.docker.client.CompressedDirectory;
import com.spotify.docker.client.ContainerNotFoundException;
import com.spotify.docker.client.DockerCertificates;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.DockerRequestException;
import com.spotify.docker.client.DockerTimeoutException;
import com.spotify.docker.client.ImageNotFoundException;
import com.spotify.docker.client.ImageRef;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.LoggingBuildHandler;
import com.spotify.docker.client.LoggingPullHandler;
import com.spotify.docker.client.LoggingPushHandler;
import com.spotify.docker.client.LogsResponseReader;
import com.spotify.docker.client.ObjectMapperProvider;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.ProgressResponseReader;
import com.spotify.docker.client.ProgressStream;
import com.spotify.docker.client.UnixConnectionSocketFactory;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerExit;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.Image;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.docker.client.messages.Info;
import com.spotify.docker.client.messages.ProgressMessage;
import com.spotify.docker.client.messages.RemovedImage;
import com.spotify.docker.client.messages.Version;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.spotify.docker.client.shaded.javax.ws.rs.ProcessingException;
import com.spotify.docker.client.shaded.javax.ws.rs.WebApplicationException;
import com.spotify.docker.client.shaded.javax.ws.rs.client.Client;
import com.spotify.docker.client.shaded.javax.ws.rs.client.ClientBuilder;
import com.spotify.docker.client.shaded.javax.ws.rs.client.Entity;
import com.spotify.docker.client.shaded.javax.ws.rs.client.Invocation;
import com.spotify.docker.client.shaded.javax.ws.rs.client.ResponseProcessingException;
import com.spotify.docker.client.shaded.javax.ws.rs.client.WebTarget;
import com.spotify.docker.client.shaded.javax.ws.rs.core.GenericType;
import com.spotify.docker.client.shaded.javax.ws.rs.core.MediaType;
import com.spotify.docker.client.shaded.javax.ws.rs.core.Response;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StringWriter;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDockerClient
implements DockerClient,
Closeable {
    private static final String VERSION = "v1.12";
    private static final Logger log = LoggerFactory.getLogger(DefaultDockerClient.class);
    public static final long NO_TIMEOUT = 0L;
    private static final long DEFAULT_CONNECT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    private static final long DEFAULT_READ_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private static final ClientConfig DEFAULT_CONFIG = new ClientConfig(ObjectMapperProvider.class, JacksonFeature.class, LogsResponseReader.class, ProgressResponseReader.class);
    private static final Pattern CONTAINER_NAME_PATTERN = Pattern.compile("/?[a-zA-Z0-9_-]+");
    private static final GenericType<List<Container>> CONTAINER_LIST = new GenericType<List<Container>>(){};
    private static final GenericType<List<Image>> IMAGE_LIST = new GenericType<List<Image>>(){};
    private static final GenericType<List<RemovedImage>> REMOVED_IMAGE_LIST = new GenericType<List<RemovedImage>>(){};
    private static final AtomicInteger CLIENT_COUNTER = new AtomicInteger();
    private final ExecutorService executor = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("docker-client-" + CLIENT_COUNTER.incrementAndGet() + "-%d").build())));
    private final Client client;
    private final URI uri;

    public DefaultDockerClient(String uri) {
        this(URI.create(uri.replaceAll("^unix:///", "unix://localhost/")));
    }

    public DefaultDockerClient(URI uri) {
        this(new Builder().uri(uri));
    }

    public DefaultDockerClient(URI uri, DockerCertificates dockerCertificates) {
        this(new Builder().uri(uri).dockerCertificates(dockerCertificates));
    }

    private DefaultDockerClient(Builder builder) {
        URI originalUri = (URI)Preconditions.checkNotNull((Object)builder.uri, (Object)"uri");
        if (builder.dockerCertificates != null && !originalUri.getScheme().equals("https")) {
            throw new IllegalArgumentException("https URI must be provided to use certificates");
        }
        this.uri = originalUri.getScheme().equals("unix") ? UnixConnectionSocketFactory.sanitizeUri(originalUri) : originalUri;
        ClientConfig config = DEFAULT_CONFIG.connectorProvider(new ApacheConnectorProvider()).property("jersey.config.client.connectTimeout", (int)builder.connectTimeoutMillis).property("jersey.config.client.readTimeout", (int)builder.readTimeoutMillis).property("jersey.config.apache.client.connectionManager", new PoolingHttpClientConnectionManager(this.getSchemeRegistry(builder)));
        this.client = ClientBuilder.newClient(config);
    }

    private Registry<ConnectionSocketFactory> getSchemeRegistry(Builder builder) {
        SSLConnectionSocketFactory https = builder.dockerCertificates == null ? SSLConnectionSocketFactory.getSocketFactory() : new SSLConnectionSocketFactory(builder.dockerCertificates.sslContext(), builder.dockerCertificates.hostnameVerifier());
        return RegistryBuilder.create().register("https", (Object)https).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("unix", (Object)new UnixConnectionSocketFactory(builder.uri)).build();
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
        this.client.close();
    }

    @Override
    public String ping() throws DockerException, InterruptedException {
        WebTarget resource = this.client.target(this.uri).path("_ping");
        return this.request("GET", String.class, resource, resource.request());
    }

    @Override
    public Version version() throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("version");
        return this.request("GET", Version.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public Info info() throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("info");
        return this.request("GET", Info.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public List<Container> listContainers(DockerClient.ListContainersParam ... params) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path("json");
        for (DockerClient.ListContainersParam param : params) {
            resource = resource.queryParam(param.name(), param.value());
        }
        return this.request("GET", CONTAINER_LIST, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public List<Image> listImages(DockerClient.ListImagesParam ... params) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("images").path("json");
        HashMap filters = Maps.newHashMap();
        for (DockerClient.ListImagesParam param : params) {
            if (param instanceof DockerClient.ListImagesFilterParam) {
                filters.put(param.name(), param.value());
                continue;
            }
            resource = resource.queryParam(param.name(), param.value());
        }
        try {
            if (!filters.isEmpty()) {
                StringWriter writer = new StringWriter();
                JsonGenerator generator = ObjectMapperProvider.objectMapper().getFactory().createGenerator(writer);
                generator.writeStartObject();
                for (Map.Entry entry : filters.entrySet()) {
                    generator.writeArrayFieldStart((String)entry.getKey());
                    generator.writeString((String)entry.getValue());
                    generator.writeEndArray();
                }
                generator.writeEndObject();
                generator.close();
                String encoded = URLEncoder.encode(writer.toString(), StandardCharsets.UTF_8.name());
                resource = resource.queryParam("filters", encoded);
            }
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
        return this.request("GET", IMAGE_LIST, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public ContainerCreation createContainer(ContainerConfig config) throws DockerException, InterruptedException {
        return this.createContainer(config, null);
    }

    @Override
    public ContainerCreation createContainer(ContainerConfig config, String name) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path("create");
        if (name != null) {
            Preconditions.checkArgument((boolean)CONTAINER_NAME_PATTERN.matcher(name).matches(), (String)"Invalid container name: \"%s\"", (Object[])new Object[]{name});
            resource = resource.queryParam("name", name);
        }
        log.info("Creating container with ContainerConfig: {}", (Object)config);
        try {
            return this.request("POST", ContainerCreation.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE), Entity.json(config));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(config.image(), e);
                }
            }
            throw e;
        }
    }

    @Override
    public void startContainer(String containerId) throws DockerException, InterruptedException {
        this.startContainer(containerId, HostConfig.builder().build());
    }

    @Override
    public void startContainer(String containerId, HostConfig hostConfig) throws DockerException, InterruptedException {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId");
        Preconditions.checkNotNull((Object)hostConfig, (Object)"hostConfig");
        log.info("Starting container with HostConfig: {}", (Object)hostConfig);
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path("start");
            this.request("POST", resource, resource.request(MediaType.APPLICATION_JSON_TYPE).property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED), Entity.json(hostConfig));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void restartContainer(String containerId) throws DockerException, InterruptedException {
        this.restartContainer(containerId, 10);
    }

    @Override
    public void restartContainer(String containerId, int secondsToWaitBeforeRestart) throws DockerException, InterruptedException {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId");
        Preconditions.checkNotNull((Object)secondsToWaitBeforeRestart, (Object)"secondsToWait");
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path("restart").queryParam("t", String.valueOf(secondsToWaitBeforeRestart));
            this.request("POST", resource, resource.request());
        }
        catch (WebApplicationException e) {
            switch (e.getResponse().getStatus()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw new DockerException(e);
        }
    }

    @Override
    public void killContainer(String containerId) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path("kill");
            this.request("POST", resource, resource.request());
        }
        catch (WebApplicationException e) {
            switch (e.getResponse().getStatus()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw new DockerException(e);
        }
    }

    @Override
    public void stopContainer(String containerId, int secondsToWaitBeforeKilling) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path("stop").queryParam("t", String.valueOf(secondsToWaitBeforeKilling));
            this.request("POST", resource, resource.request());
        }
        catch (WebApplicationException e) {
            switch (e.getResponse().getStatus()) {
                case 304: {
                    return;
                }
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw new DockerException(e);
        }
    }

    @Override
    public ContainerExit waitContainer(String containerId) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path("wait");
            return this.request("POST", ContainerExit.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE).property("jersey.config.client.readTimeout", 0));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void removeContainer(String containerId) throws DockerException, InterruptedException {
        this.removeContainer(containerId, false);
    }

    @Override
    public void removeContainer(String containerId, boolean removeVolumes) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("containers").path(containerId);
            this.request("DELETE", resource, resource.queryParam("v", String.valueOf(removeVolumes)).request(MediaType.APPLICATION_JSON_TYPE));
        }
        catch (WebApplicationException e) {
            switch (e.getResponse().getStatus()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId);
                }
            }
            throw new DockerException(e);
        }
    }

    @Override
    public InputStream exportContainer(String containerId) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path(containerId).path("export");
        return this.request("GET", InputStream.class, resource, resource.request(MediaType.APPLICATION_OCTET_STREAM_TYPE));
    }

    @Override
    public InputStream copyContainer(String containerId, String path) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path(containerId).path("copy");
        JsonNodeFactory nf = JsonNodeFactory.instance;
        JsonNode params = nf.objectNode().set("Resource", nf.textNode(path));
        return this.request("POST", InputStream.class, resource, resource.request(MediaType.APPLICATION_OCTET_STREAM_TYPE), Entity.json(params));
    }

    @Override
    public ContainerInfo inspectContainer(String containerId) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path("json");
            return this.request("GET", ContainerInfo.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void pull(String image) throws DockerException, InterruptedException {
        this.pull(image, new LoggingPullHandler(image));
    }

    @Override
    public void pull(String image, ProgressHandler handler) throws DockerException, InterruptedException {
        ImageRef imageRef = new ImageRef(image);
        WebTarget resource = this.resource().path("images").path("create");
        resource = resource.queryParam("fromImage", imageRef.getImage());
        if (imageRef.getTag() != null) {
            resource = resource.queryParam("tag", imageRef.getTag());
        }
        try (ProgressStream pull = this.request("POST", ProgressStream.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));){
            pull.tail(handler, "POST", resource.getUri());
        }
    }

    @Override
    public void push(String image) throws DockerException, InterruptedException {
        this.push(image, new LoggingPushHandler(image));
    }

    @Override
    public void push(String image, ProgressHandler handler) throws DockerException, InterruptedException {
        ImageRef imageRef = new ImageRef(image);
        WebTarget resource = this.resource().path("images").path(imageRef.getImage()).path("push");
        if (imageRef.getTag() != null) {
            resource = resource.queryParam("tag", imageRef.getTag());
        }
        try (ProgressStream push = this.request("POST", ProgressStream.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE).header("X-Registry-Auth", "null"));){
            push.tail(handler, "POST", resource.getUri());
        }
    }

    @Override
    public void tag(String image, String name) throws DockerException, InterruptedException {
        ImageRef imageRef = new ImageRef(name);
        WebTarget resource = this.resource().path("images").path(image).path("tag");
        resource = resource.queryParam("repo", imageRef.getImage());
        if (imageRef.getTag() != null) {
            resource = resource.queryParam("tag", imageRef.getTag());
        }
        try {
            this.request("POST", resource, resource.request());
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(image, e);
                }
            }
            throw e;
        }
    }

    @Override
    public String build(Path directory, DockerClient.BuildParameter ... params) throws DockerException, InterruptedException, IOException {
        return this.build(directory, null, new LoggingBuildHandler(), params);
    }

    @Override
    public String build(Path directory, String name, DockerClient.BuildParameter ... params) throws DockerException, InterruptedException, IOException {
        return this.build(directory, name, new LoggingBuildHandler(), params);
    }

    @Override
    public String build(Path directory, ProgressHandler handler, DockerClient.BuildParameter ... params) throws DockerException, InterruptedException, IOException {
        return this.build(directory, null, handler, params);
    }

    /*
     * Loose catch block
     */
    @Override
    public String build(Path directory, String name, ProgressHandler handler, DockerClient.BuildParameter ... params) throws DockerException, InterruptedException, IOException {
        Preconditions.checkNotNull((Object)handler, (Object)"handler");
        WebTarget resource = this.resource().path("build");
        for (DockerClient.BuildParameter param : params) {
            resource = resource.queryParam(param.queryParam, String.valueOf(param.value));
        }
        if (name != null) {
            resource = resource.queryParam("t", name);
        }
        File compressedDirectory = CompressedDirectory.create(directory);
        try {
            try (ProgressStream build = this.request("POST", ProgressStream.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE), Entity.entity(compressedDirectory, "application/tar"));){
                String imageId = null;
                while (build.hasNextMessage("POST", resource.getUri())) {
                    ProgressMessage message = build.nextMessage("POST", resource.getUri());
                    String id = message.buildImageId();
                    if (id != null) {
                        imageId = id;
                    }
                    handler.progress(message);
                }
                String string = imageId;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            CompressedDirectory.delete(compressedDirectory);
        }
    }

    @Override
    public ImageInfo inspectImage(String image) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("images").path(image).path("json");
            return this.request("GET", ImageInfo.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(image, e);
                }
            }
            throw e;
        }
    }

    @Override
    public List<RemovedImage> removeImage(String image) throws DockerException, InterruptedException {
        return this.removeImage(image, false, false);
    }

    @Override
    public List<RemovedImage> removeImage(String image, boolean force, boolean noPrune) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("images").path(image).queryParam("force", String.valueOf(force)).queryParam("noprune", String.valueOf(noPrune));
            return this.request("DELETE", REMOVED_IMAGE_LIST, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
        }
        catch (WebApplicationException e) {
            switch (e.getResponse().getStatus()) {
                case 404: {
                    throw new ImageNotFoundException(image);
                }
            }
            throw new DockerException(e);
        }
    }

    @Override
    public LogStream logs(String containerId, DockerClient.LogsParameter ... params) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path(containerId).path("logs");
        for (DockerClient.LogsParameter param : params) {
            resource = resource.queryParam(param.name().toLowerCase(Locale.ROOT), String.valueOf(true));
        }
        try {
            return this.request("GET", LogStream.class, resource, resource.request("application/vnd.docker.raw-stream"));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId);
                }
            }
            throw e;
        }
    }

    private WebTarget resource() {
        return this.client.target(this.uri).path(VERSION);
    }

    private <T> T request(String method, GenericType<T> type, WebTarget resource, Invocation.Builder request) throws DockerException, InterruptedException {
        try {
            return request.async().method(method, type).get();
        }
        catch (ExecutionException e) {
            throw this.propagate(method, resource, e);
        }
    }

    private <T> T request(String method, Class<T> clazz, WebTarget resource, Invocation.Builder request) throws DockerException, InterruptedException {
        try {
            return request.async().method(method, clazz).get();
        }
        catch (ExecutionException e) {
            throw this.propagate(method, resource, e);
        }
    }

    private <T> T request(String method, Class<T> clazz, WebTarget resource, Invocation.Builder request, Entity<?> entity) throws DockerException, InterruptedException {
        try {
            return request.async().method(method, entity, clazz).get();
        }
        catch (ExecutionException e) {
            throw this.propagate(method, resource, e);
        }
    }

    private void request(String method, WebTarget resource, Invocation.Builder request) throws DockerException, InterruptedException {
        try {
            request.async().method(method).get();
        }
        catch (ExecutionException e) {
            throw this.propagate(method, resource, e);
        }
    }

    private void request(String method, WebTarget resource, Invocation.Builder request, Entity<?> entity) throws DockerException, InterruptedException {
        try {
            request.async().method(method, entity).get();
        }
        catch (ExecutionException e) {
            throw this.propagate(method, resource, e);
        }
    }

    private RuntimeException propagate(String method, WebTarget resource, Exception e) throws DockerException, InterruptedException {
        Throwable cause = e.getCause();
        Response response = null;
        if (cause instanceof ResponseProcessingException) {
            response = ((ResponseProcessingException)cause).getResponse();
        } else if (cause instanceof WebApplicationException) {
            response = ((WebApplicationException)cause).getResponse();
        } else if (cause instanceof ProcessingException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (response != null) {
            throw new DockerRequestException(method, resource.getUri(), response.getStatus(), this.message(response), cause);
        }
        if (cause instanceof SocketTimeoutException || cause instanceof ConnectTimeoutException) {
            throw new DockerTimeoutException(method, resource.getUri(), e);
        }
        if (cause instanceof InterruptedIOException) {
            throw new InterruptedException("Interrupted: " + method + " " + resource);
        }
        throw new DockerException(e);
    }

    private String message(Response response) {
        InputStreamReader reader = new InputStreamReader(response.readEntity(InputStream.class), StandardCharsets.UTF_8);
        try {
            return CharStreams.toString((Readable)reader);
        }
        catch (IOException ignore) {
            return null;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ long access$400() {
        return DEFAULT_CONNECT_TIMEOUT_MILLIS;
    }

    static /* synthetic */ long access$500() {
        return DEFAULT_READ_TIMEOUT_MILLIS;
    }

    public static class Builder {
        private URI uri;
        private long connectTimeoutMillis = DefaultDockerClient.access$400();
        private long readTimeoutMillis = DefaultDockerClient.access$500();
        private DockerCertificates dockerCertificates;

        public URI uri() {
            return this.uri;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder uri(String uri) {
            return this.uri(URI.create(uri));
        }

        public long connectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        public Builder connectTimeoutMillis(long connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        public long readTimeoutMillis() {
            return this.readTimeoutMillis;
        }

        public Builder readTimeoutMillis(long readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public DockerCertificates dockerCertificates() {
            return this.dockerCertificates;
        }

        public Builder dockerCertificates(DockerCertificates dockerCertificates) {
            this.dockerCertificates = dockerCertificates;
            return this;
        }

        public DefaultDockerClient build() {
            return new DefaultDockerClient(this);
        }
    }
}

