/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.com.fasterxml.jackson.databind;

import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.Base64Variant;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.FormatSchema;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonEncoding;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonFactory;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonParser;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.PrettyPrinter;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.Version;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.Versioned;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.type.TypeReference;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.util.Instantiatable;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JavaType;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.MapperFeature;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ser.FilterProvider;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;

public class ObjectWriter
implements Versioned,
Serializable {
    private static final long serialVersionUID = -7024829992408267532L;
    protected static final PrettyPrinter NULL_PRETTY_PRINTER = new MinimalPrettyPrinter();
    protected final SerializationConfig _config;
    protected final DefaultSerializerProvider _serializerProvider;
    protected final SerializerFactory _serializerFactory;
    protected final JsonFactory _jsonFactory;
    protected final JavaType _rootType;
    protected final JsonSerializer<Object> _rootSerializer;
    protected final PrettyPrinter _prettyPrinter;
    protected final FormatSchema _schema;

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig, JavaType javaType, PrettyPrinter prettyPrinter) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._jsonFactory = objectMapper._jsonFactory;
        if (javaType != null) {
            javaType = javaType.withStaticTyping();
        }
        this._rootType = javaType;
        this._prettyPrinter = prettyPrinter;
        this._schema = null;
        this._rootSerializer = this._prefetchRootSerializer(serializationConfig, javaType);
    }

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._jsonFactory = objectMapper._jsonFactory;
        this._rootType = null;
        this._rootSerializer = null;
        this._prettyPrinter = null;
        this._schema = null;
    }

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig, FormatSchema formatSchema) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._jsonFactory = objectMapper._jsonFactory;
        this._rootType = null;
        this._rootSerializer = null;
        this._prettyPrinter = null;
        this._schema = formatSchema;
    }

    protected ObjectWriter(ObjectWriter objectWriter, SerializationConfig serializationConfig, JavaType javaType, JsonSerializer<Object> jsonSerializer, PrettyPrinter prettyPrinter, FormatSchema formatSchema) {
        this._config = serializationConfig;
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._jsonFactory = objectWriter._jsonFactory;
        this._rootType = javaType;
        this._rootSerializer = jsonSerializer;
        this._prettyPrinter = prettyPrinter;
        this._schema = formatSchema;
    }

    protected ObjectWriter(ObjectWriter objectWriter, SerializationConfig serializationConfig) {
        this._config = serializationConfig;
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._jsonFactory = objectWriter._jsonFactory;
        this._schema = objectWriter._schema;
        this._rootType = objectWriter._rootType;
        this._rootSerializer = objectWriter._rootSerializer;
        this._prettyPrinter = objectWriter._prettyPrinter;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public ObjectWriter with(SerializationFeature serializationFeature) {
        SerializationConfig serializationConfig = this._config.with(serializationFeature);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter with(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        SerializationConfig serializationConfig = this._config.with(serializationFeature, serializationFeatureArray);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter withFeatures(SerializationFeature ... serializationFeatureArray) {
        SerializationConfig serializationConfig = this._config.withFeatures(serializationFeatureArray);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter without(SerializationFeature serializationFeature) {
        SerializationConfig serializationConfig = this._config.without(serializationFeature);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter without(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        SerializationConfig serializationConfig = this._config.without(serializationFeature, serializationFeatureArray);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter withoutFeatures(SerializationFeature ... serializationFeatureArray) {
        SerializationConfig serializationConfig = this._config.withoutFeatures(serializationFeatureArray);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter with(DateFormat dateFormat) {
        SerializationConfig serializationConfig = this._config.with(dateFormat);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter withDefaultPrettyPrinter() {
        return this.with(new DefaultPrettyPrinter());
    }

    public ObjectWriter with(FilterProvider filterProvider) {
        if (filterProvider == this._config.getFilterProvider()) {
            return this;
        }
        return new ObjectWriter(this, this._config.withFilters(filterProvider));
    }

    public ObjectWriter with(PrettyPrinter prettyPrinter) {
        if (prettyPrinter == this._prettyPrinter) {
            return this;
        }
        if (prettyPrinter == null) {
            prettyPrinter = NULL_PRETTY_PRINTER;
        }
        return new ObjectWriter(this, this._config, this._rootType, this._rootSerializer, prettyPrinter, this._schema);
    }

    public ObjectWriter withRootName(String string) {
        SerializationConfig serializationConfig = this._config.withRootName(string);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter withSchema(FormatSchema formatSchema) {
        if (this._schema == formatSchema) {
            return this;
        }
        this._verifySchemaType(formatSchema);
        return new ObjectWriter(this, this._config, this._rootType, this._rootSerializer, this._prettyPrinter, formatSchema);
    }

    public ObjectWriter withType(JavaType javaType) {
        javaType = javaType.withStaticTyping();
        JsonSerializer<Object> jsonSerializer = this._prefetchRootSerializer(this._config, javaType);
        return new ObjectWriter(this, this._config, javaType, jsonSerializer, this._prettyPrinter, this._schema);
    }

    public ObjectWriter withType(Class<?> clazz) {
        return this.withType(this._config.constructType(clazz));
    }

    public ObjectWriter withType(TypeReference<?> typeReference) {
        return this.withType(this._config.getTypeFactory().constructType(typeReference.getType()));
    }

    public ObjectWriter withView(Class<?> clazz) {
        MapperConfigBase mapperConfigBase = this._config.withView((Class)clazz);
        return mapperConfigBase == this._config ? this : new ObjectWriter(this, (SerializationConfig)mapperConfigBase);
    }

    public ObjectWriter with(Locale locale) {
        SerializationConfig serializationConfig = this._config.with(locale);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter with(TimeZone timeZone) {
        SerializationConfig serializationConfig = this._config.with(timeZone);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter with(Base64Variant base64Variant) {
        SerializationConfig serializationConfig = this._config.with(base64Variant);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public boolean isEnabled(SerializationFeature serializationFeature) {
        return this._config.isEnabled(serializationFeature);
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    public boolean isEnabled(JsonParser.Feature feature) {
        return this._jsonFactory.isEnabled(feature);
    }

    public SerializationConfig getConfig() {
        return this._config;
    }

    @Deprecated
    public JsonFactory getJsonFactory() {
        return this._jsonFactory;
    }

    public JsonFactory getFactory() {
        return this._jsonFactory;
    }

    public TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public boolean hasPrefetchedSerializer() {
        return this._rootSerializer != null;
    }

    public void writeValue(JsonGenerator jsonGenerator, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configureJsonGenerator(jsonGenerator);
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseableValue(jsonGenerator, object, this._config);
        } else {
            if (this._rootType == null) {
                this._serializerProvider(this._config).serializeValue(jsonGenerator, object);
            } else {
                this._serializerProvider(this._config).serializeValue(jsonGenerator, object, this._rootType, this._rootSerializer);
            }
            if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
        }
    }

    public void writeValue(File file, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._jsonFactory.createGenerator(file, JsonEncoding.UTF8), object);
    }

    public void writeValue(OutputStream outputStream, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._jsonFactory.createGenerator(outputStream, JsonEncoding.UTF8), object);
    }

    public void writeValue(Writer writer, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._jsonFactory.createGenerator(writer), object);
    }

    public String writeValueAsString(Object object) throws JsonProcessingException {
        SegmentedStringWriter segmentedStringWriter = new SegmentedStringWriter(this._jsonFactory._getBufferRecycler());
        try {
            this._configAndWriteValue(this._jsonFactory.createGenerator(segmentedStringWriter), object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
        return segmentedStringWriter.getAndClear();
    }

    public byte[] writeValueAsBytes(Object object) throws JsonProcessingException {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(this._jsonFactory._getBufferRecycler());
        try {
            this._configAndWriteValue(this._jsonFactory.createGenerator(byteArrayBuilder, JsonEncoding.UTF8), object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
        byte[] byArray = byteArrayBuilder.toByteArray();
        byteArrayBuilder.release();
        return byArray;
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) throws JsonMappingException {
        if (javaType == null) {
            throw new IllegalArgumentException("type must be provided");
        }
        this._serializerProvider(this._config).acceptJsonFormatVisitor(javaType, jsonFormatVisitorWrapper);
    }

    public boolean canSerialize(Class<?> clazz) {
        return this._serializerProvider(this._config).hasSerializerFor(clazz);
    }

    protected DefaultSerializerProvider _serializerProvider(SerializationConfig serializationConfig) {
        return this._serializerProvider.createInstance(serializationConfig, this._serializerFactory);
    }

    protected void _verifySchemaType(FormatSchema formatSchema) {
        if (formatSchema != null && !this._jsonFactory.canUseSchema(formatSchema)) {
            throw new IllegalArgumentException("Can not use FormatSchema of type " + formatSchema.getClass().getName() + " for format " + this._jsonFactory.getFormatName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void _configAndWriteValue(JsonGenerator jsonGenerator, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configureJsonGenerator(jsonGenerator);
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseable(jsonGenerator, object, this._config);
            return;
        }
        boolean bl = false;
        try {
            if (this._rootType == null) {
                this._serializerProvider(this._config).serializeValue(jsonGenerator, object);
            } else {
                this._serializerProvider(this._config).serializeValue(jsonGenerator, object, this._rootType, this._rootSerializer);
            }
            bl = true;
            jsonGenerator.close();
        }
        finally {
            if (!bl) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _writeCloseable(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) throws IOException, JsonGenerationException, JsonMappingException {
        Closeable closeable = (Closeable)object;
        try {
            if (this._rootType == null) {
                this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            } else {
                this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object, this._rootType, this._rootSerializer);
            }
            JsonGenerator jsonGenerator2 = jsonGenerator;
            jsonGenerator = null;
            jsonGenerator2.close();
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        finally {
            if (jsonGenerator != null) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _writeCloseableValue(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) throws IOException, JsonGenerationException, JsonMappingException {
        Closeable closeable = (Closeable)object;
        try {
            if (this._rootType == null) {
                this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            } else {
                this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object, this._rootType, this._rootSerializer);
            }
            if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        finally {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected JsonSerializer<Object> _prefetchRootSerializer(SerializationConfig serializationConfig, JavaType javaType) {
        if (javaType == null || !this._config.isEnabled(SerializationFeature.EAGER_SERIALIZER_FETCH)) {
            return null;
        }
        try {
            return this._serializerProvider(serializationConfig).findTypedValueSerializer(javaType, true, null);
        }
        catch (JsonProcessingException jsonProcessingException) {
            return null;
        }
    }

    private void _configureJsonGenerator(JsonGenerator jsonGenerator) {
        if (this._prettyPrinter != null) {
            PrettyPrinter prettyPrinter = this._prettyPrinter;
            if (prettyPrinter == NULL_PRETTY_PRINTER) {
                jsonGenerator.setPrettyPrinter(null);
            } else {
                if (prettyPrinter instanceof Instantiatable) {
                    prettyPrinter = (PrettyPrinter)((Instantiatable)((Object)prettyPrinter)).createInstance();
                }
                jsonGenerator.setPrettyPrinter(prettyPrinter);
            }
        } else if (this._config.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        if (this._schema != null) {
            jsonGenerator.setSchema(this._schema);
        }
    }
}

