/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompressedDirectory {
    private static final Logger log = LoggerFactory.getLogger(CompressedDirectory.class);
    private static final int DEFAULT_FILE_MODE = 33188;
    private static final String POSIX_FILE_VIEW = "posix";

    CompressedDirectory() {
    }

    public static File create(String directory) throws IOException {
        return CompressedDirectory.create(Paths.get(directory, new String[0]));
    }

    public static File create(Path directory) throws IOException {
        File file = File.createTempFile("docker-client-", ".tar.gz");
        try (FileOutputStream fileOut = new FileOutputStream(file);
             GzipCompressorOutputStream gzipOut = new GzipCompressorOutputStream((OutputStream)fileOut);
             TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)gzipOut);){
            tarOut.setLongFileMode(3);
            tarOut.setBigNumberMode(2);
            Files.walkFileTree(directory, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new Visitor(directory, tarOut));
        }
        catch (Throwable t) {
            CompressedDirectory.delete(file);
            throw t;
        }
        return file;
    }

    public static boolean delete(File file) {
        boolean deleted;
        if (file == null) {
            return false;
        }
        try {
            deleted = file.delete();
        }
        catch (Exception ignored) {
            deleted = false;
        }
        if (!deleted) {
            log.warn("Failed to delete temporary file {}", (Object)file.getPath());
        }
        return deleted;
    }

    private static class Visitor
    extends SimpleFileVisitor<Path> {
        private final Path root;
        private final TarArchiveOutputStream tarStream;

        private Visitor(Path root, TarArchiveOutputStream tarStream) {
            this.root = root;
            this.tarStream = tarStream;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            TarArchiveEntry entry = new TarArchiveEntry(file.toFile());
            Path relativePath = this.root.relativize(file);
            entry.setName(relativePath.toString());
            entry.setMode(Visitor.getFileMode(file));
            entry.setSize(attrs.size());
            this.tarStream.putArchiveEntry((ArchiveEntry)entry);
            Files.copy(file, (OutputStream)this.tarStream);
            this.tarStream.closeArchiveEntry();
            return FileVisitResult.CONTINUE;
        }

        private static int getFileMode(Path file) throws IOException {
            if (Visitor.isPosixComplantFS()) {
                return Visitor.getPosixFileMode(file);
            }
            return 33188;
        }

        private static boolean isPosixComplantFS() {
            return FileSystems.getDefault().supportedFileAttributeViews().contains(CompressedDirectory.POSIX_FILE_VIEW);
        }

        private static int getPosixFileMode(Path file) throws IOException {
            PosixFileAttributes attr = Files.readAttributes(file, PosixFileAttributes.class, new LinkOption[0]);
            Set<PosixFilePermission> perm = attr.permissions();
            int mode = 32768;
            mode += 64 * Visitor.getModeFromPermissions(perm.contains((Object)PosixFilePermission.OWNER_READ), perm.contains((Object)PosixFilePermission.OWNER_WRITE), perm.contains((Object)PosixFilePermission.OWNER_EXECUTE));
            mode += 8 * Visitor.getModeFromPermissions(perm.contains((Object)PosixFilePermission.GROUP_READ), perm.contains((Object)PosixFilePermission.GROUP_WRITE), perm.contains((Object)PosixFilePermission.GROUP_EXECUTE));
            return mode += Visitor.getModeFromPermissions(perm.contains((Object)PosixFilePermission.OTHERS_READ), perm.contains((Object)PosixFilePermission.OTHERS_WRITE), perm.contains((Object)PosixFilePermission.OTHERS_EXECUTE));
        }

        private static int getModeFromPermissions(boolean read, boolean write, boolean execute) {
            int result = 0;
            if (read) {
                result += 4;
            }
            if (write) {
                result += 2;
            }
            if (execute) {
                ++result;
            }
            return result;
        }
    }
}

