/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.messages.AuthConfig;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerExit;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.Image;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.docker.client.messages.ImageSearchResult;
import com.spotify.docker.client.messages.Info;
import com.spotify.docker.client.messages.RemovedImage;
import com.spotify.docker.client.messages.Version;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;

public interface DockerClient
extends Closeable {
    public String ping() throws DockerException, InterruptedException;

    public Version version() throws DockerException, InterruptedException;

    public int auth(AuthConfig var1) throws DockerException, InterruptedException;

    public Info info() throws DockerException, InterruptedException;

    public List<Container> listContainers(ListContainersParam ... var1) throws DockerException, InterruptedException;

    public List<Image> listImages(ListImagesParam ... var1) throws DockerException, InterruptedException;

    public ContainerInfo inspectContainer(String var1) throws DockerException, InterruptedException;

    public ContainerCreation commitContainer(String var1, String var2, String var3, ContainerConfig var4, String var5, String var6) throws DockerException, InterruptedException;

    public ImageInfo inspectImage(String var1) throws DockerException, InterruptedException;

    public List<RemovedImage> removeImage(String var1) throws DockerException, InterruptedException;

    public List<RemovedImage> removeImage(String var1, boolean var2, boolean var3) throws DockerException, InterruptedException;

    public List<ImageSearchResult> searchImages(String var1) throws DockerException, InterruptedException;

    public void pull(String var1) throws DockerException, InterruptedException;

    public void pull(String var1, ProgressHandler var2) throws DockerException, InterruptedException;

    public void pull(String var1, AuthConfig var2) throws DockerException, InterruptedException;

    public void pull(String var1, AuthConfig var2, ProgressHandler var3) throws DockerException, InterruptedException;

    public void push(String var1) throws DockerException, InterruptedException;

    public void push(String var1, ProgressHandler var2) throws DockerException, InterruptedException;

    public void tag(String var1, String var2) throws DockerException, InterruptedException;

    public void tag(String var1, String var2, boolean var3) throws DockerException, InterruptedException;

    public String build(Path var1, BuildParameter ... var2) throws DockerException, InterruptedException, IOException;

    public String build(Path var1, String var2, BuildParameter ... var3) throws DockerException, InterruptedException, IOException;

    public String build(Path var1, ProgressHandler var2, BuildParameter ... var3) throws DockerException, InterruptedException, IOException;

    public String build(Path var1, String var2, ProgressHandler var3, BuildParameter ... var4) throws DockerException, InterruptedException, IOException;

    public ContainerCreation createContainer(ContainerConfig var1) throws DockerException, InterruptedException;

    public ContainerCreation createContainer(ContainerConfig var1, String var2) throws DockerException, InterruptedException;

    public void startContainer(String var1) throws DockerException, InterruptedException;

    public void startContainer(String var1, HostConfig var2) throws DockerException, InterruptedException;

    public void stopContainer(String var1, int var2) throws DockerException, InterruptedException;

    public void pauseContainer(String var1) throws DockerException, InterruptedException;

    public void unpauseContainer(String var1) throws DockerException, InterruptedException;

    public void restartContainer(String var1) throws DockerException, InterruptedException;

    public void restartContainer(String var1, int var2) throws DockerException, InterruptedException;

    public ContainerExit waitContainer(String var1) throws DockerException, InterruptedException;

    public void killContainer(String var1) throws DockerException, InterruptedException;

    public void removeContainer(String var1) throws DockerException, InterruptedException;

    public void removeContainer(String var1, boolean var2) throws DockerException, InterruptedException;

    public InputStream exportContainer(String var1) throws DockerException, InterruptedException;

    public InputStream copyContainer(String var1, String var2) throws DockerException, InterruptedException;

    public LogStream logs(String var1, LogsParameter ... var2) throws DockerException, InterruptedException;

    public String execCreate(String var1, String[] var2, ExecParameter ... var3) throws DockerException, InterruptedException;

    public LogStream execStart(String var1, ExecStartParameter ... var2) throws DockerException, InterruptedException;

    @Override
    public void close();

    public LogStream attachContainer(String var1, AttachParameter ... var2) throws DockerException, InterruptedException;

    public String getHost();

    public static class ListImagesFilterParam
    extends ListImagesParam {
        public ListImagesFilterParam(String name, String value) {
            super(name, value);
        }
    }

    public static class ListImagesParam {
        private final String name;
        private final String value;

        public ListImagesParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public static ListImagesParam allImages() {
            return ListImagesParam.allImages(true);
        }

        public static ListImagesParam allImages(boolean all) {
            return ListImagesParam.create("all", String.valueOf(all));
        }

        public static ListImagesParam danglingImages() {
            return ListImagesParam.danglingImages(true);
        }

        public static ListImagesParam danglingImages(boolean dangling) {
            return ListImagesParam.filter("dangling", String.valueOf(dangling));
        }

        public static ListImagesParam filter(String name, String value) {
            return new ListImagesFilterParam(name, value);
        }

        public static ListImagesParam create(String name, String value) {
            return new ListImagesParam(name, value);
        }
    }

    public static class ListContainersParam {
        private final String name;
        private final String value;

        public ListContainersParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public static ListContainersParam allContainers() {
            return ListContainersParam.allContainers(true);
        }

        public static ListContainersParam allContainers(boolean all) {
            return ListContainersParam.create("all", String.valueOf(all));
        }

        public static ListContainersParam limitContainers(Integer limit) {
            return ListContainersParam.create("limit", String.valueOf(limit));
        }

        public static ListContainersParam containersCreatedSince(String id) {
            return ListContainersParam.create("since", String.valueOf(id));
        }

        public static ListContainersParam containersCreatedBefore(String id) {
            return ListContainersParam.create("before", String.valueOf(id));
        }

        public static ListContainersParam withContainerSizes(Boolean size) {
            return ListContainersParam.create("size", String.valueOf(size));
        }

        public static ListContainersParam create(String name, String value) {
            return new ListContainersParam(name, value);
        }
    }

    public static enum AttachParameter {
        LOGS,
        STREAM,
        STDIN,
        STDOUT,
        STDERR;

    }

    public static enum LogsParameter {
        FOLLOW,
        STDOUT,
        STDERR,
        TIMESTAMPS;

    }

    public static enum ExecStartParameter {
        DETACH("Detach");

        private final String name;

        private ExecStartParameter(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum ExecParameter {
        STDOUT("AttachStdout"),
        STDERR("AttachStderr");

        private final String name;

        private ExecParameter(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum BuildParameter {
        QUIET("q", true),
        NO_CACHE("nocache", true),
        NO_RM("rm", false),
        FORCE_RM("forcerm", true);

        final String queryParam;
        final boolean value;

        private BuildParameter(String queryParam, boolean value) {
            this.queryParam = queryParam;
            this.value = value;
        }
    }
}

