/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class PortBinding {
    @JsonProperty(value="HostIp")
    private String hostIp;
    @JsonProperty(value="HostPort")
    private String hostPort;

    public String hostIp() {
        return this.hostIp;
    }

    public void hostIp(String hostIp) {
        this.hostIp = hostIp;
    }

    public String hostPort() {
        return this.hostPort;
    }

    public void hostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public static PortBinding of(String ip, String port) {
        PortBinding binding = new PortBinding();
        binding.hostIp(ip);
        binding.hostPort(port);
        return binding;
    }

    public static PortBinding of(String ip, int port) {
        return PortBinding.of(ip, String.valueOf(port));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortBinding that = (PortBinding)o;
        if (this.hostIp != null ? !this.hostIp.equals(that.hostIp) : that.hostIp != null) {
            return false;
        }
        return !(this.hostPort != null ? !this.hostPort.equals(that.hostPort) : that.hostPort != null);
    }

    public int hashCode() {
        int result = this.hostIp != null ? this.hostIp.hashCode() : 0;
        result = 31 * result + (this.hostPort != null ? this.hostPort.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("hostIp", (Object)this.hostIp).add("hostPort", (Object)this.hostPort).toString();
    }
}

