/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class NetworkSettings {
    @JsonProperty(value="IPAddress")
    private String ipAddress;
    @JsonProperty(value="IPPrefixLen")
    private Integer ipPrefixLen;
    @JsonProperty(value="Gateway")
    private String gateway;
    @JsonProperty(value="Bridge")
    private String bridge;
    @JsonProperty(value="PortMapping")
    private ImmutableMap<String, Map<String, String>> portMapping;
    @JsonProperty(value="Ports")
    private Map<String, List<PortBinding>> ports;

    private NetworkSettings() {
    }

    private NetworkSettings(Builder builder) {
        this.ipAddress = builder.ipAddress;
        this.ipPrefixLen = builder.ipPrefixLen;
        this.gateway = builder.gateway;
        this.bridge = builder.bridge;
        this.portMapping = builder.portMapping;
        this.ports = builder.ports;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public Integer ipPrefixLen() {
        return this.ipPrefixLen;
    }

    public String gateway() {
        return this.gateway;
    }

    public String bridge() {
        return this.bridge;
    }

    public Map<String, Map<String, String>> portMapping() {
        return this.portMapping;
    }

    public Map<String, List<PortBinding>> ports() {
        return this.ports == null ? null : Collections.unmodifiableMap(this.ports);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkSettings that = (NetworkSettings)o;
        if (this.bridge != null ? !this.bridge.equals(that.bridge) : that.bridge != null) {
            return false;
        }
        if (this.gateway != null ? !this.gateway.equals(that.gateway) : that.gateway != null) {
            return false;
        }
        if (this.ipAddress != null ? !this.ipAddress.equals(that.ipAddress) : that.ipAddress != null) {
            return false;
        }
        if (this.ipPrefixLen != null ? !this.ipPrefixLen.equals(that.ipPrefixLen) : that.ipPrefixLen != null) {
            return false;
        }
        if (this.portMapping != null ? !this.portMapping.equals(that.portMapping) : that.portMapping != null) {
            return false;
        }
        return !(this.ports != null ? !this.ports.equals(that.ports) : that.ports != null);
    }

    public int hashCode() {
        int result = this.ipAddress != null ? this.ipAddress.hashCode() : 0;
        result = 31 * result + (this.ipPrefixLen != null ? this.ipPrefixLen.hashCode() : 0);
        result = 31 * result + (this.gateway != null ? this.gateway.hashCode() : 0);
        result = 31 * result + (this.bridge != null ? this.bridge.hashCode() : 0);
        result = 31 * result + (this.portMapping != null ? this.portMapping.hashCode() : 0);
        result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("ipAddress", (Object)this.ipAddress).add("ipPrefixLen", (Object)this.ipPrefixLen).add("gateway", (Object)this.gateway).add("bridge", (Object)this.bridge).add("portMapping", this.portMapping).add("ports", this.ports).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String ipAddress;
        private Integer ipPrefixLen;
        private String gateway;
        private String bridge;
        private ImmutableMap<String, Map<String, String>> portMapping;
        private Map<String, List<PortBinding>> ports;

        private Builder() {
        }

        private Builder(NetworkSettings networkSettings) {
            this.ipAddress = networkSettings.ipAddress;
            this.ipPrefixLen = networkSettings.ipPrefixLen;
            this.gateway = networkSettings.gateway;
            this.bridge = networkSettings.bridge;
            this.portMapping = networkSettings.portMapping;
            this.ports = networkSettings.ports;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder ipPrefixLen(Integer ipPrefixLen) {
            this.ipPrefixLen = ipPrefixLen;
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder bridge(String bridge) {
            this.bridge = bridge;
            return this;
        }

        public Builder portMapping(Map<String, Map<String, String>> portMapping) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<String, Map<String, String>> entry : portMapping.entrySet()) {
                builder.put((Object)entry.getKey(), (Object)ImmutableMap.copyOf(entry.getValue()));
            }
            this.portMapping = builder.build();
            return this;
        }

        public Builder ports(Map<String, List<PortBinding>> ports) {
            this.ports = ports == null ? null : Maps.newHashMap(ports);
            return this;
        }

        public NetworkSettings build() {
            return new NetworkSettings(this);
        }
    }
}

