/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava;

import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.EnumMultiset;
import com.google.common.collect.ForwardingListMultimap;
import com.google.common.collect.ForwardingSetMultimap;
import com.google.common.collect.ForwardingSortedSetMultimap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.TreeMultiset;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.BeanDescription;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JavaType;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.KeyDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.deser.Deserializers;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.type.CollectionType;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.type.MapLikeType;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.type.MapType;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.deser.GuavaOptionalDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.deser.HashMultisetDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.deser.ImmutableBiMapDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.deser.ImmutableListDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.deser.ImmutableMapDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.deser.ImmutableMultisetDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.deser.ImmutableSetDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.deser.ImmutableSortedMapDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.deser.ImmutableSortedSetDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.deser.LinkedHashMultisetDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.deser.TreeMultisetDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.deser.multimap.list.ArrayListMultimapDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.deser.multimap.list.LinkedListMultimapDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.deser.multimap.set.HashMultimapDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.deser.multimap.set.LinkedHashMultimapDeserializer;

public class GuavaDeserializers
extends Deserializers.Base {
    @Override
    public JsonDeserializer<?> findCollectionDeserializer(CollectionType collectionType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        Class<?> clazz = collectionType.getRawClass();
        if (ImmutableCollection.class.isAssignableFrom(clazz)) {
            if (ImmutableList.class.isAssignableFrom(clazz)) {
                return new ImmutableListDeserializer(collectionType, typeDeserializer, jsonDeserializer);
            }
            if (ImmutableMultiset.class.isAssignableFrom(clazz)) {
                return new ImmutableMultisetDeserializer(collectionType, typeDeserializer, jsonDeserializer);
            }
            if (ImmutableSet.class.isAssignableFrom(clazz)) {
                if (ImmutableSortedSet.class.isAssignableFrom(clazz)) {
                    Class<?> clazz2 = collectionType.getContentType().getRawClass();
                    if (!Comparable.class.isAssignableFrom(clazz2)) {
                        throw new IllegalArgumentException("Can not handle ImmutableSortedSet with elements that are not Comparable<?> (" + clazz.getName() + ")");
                    }
                    return new ImmutableSortedSetDeserializer(collectionType, typeDeserializer, jsonDeserializer);
                }
                return new ImmutableSetDeserializer(collectionType, typeDeserializer, jsonDeserializer);
            }
            return new ImmutableListDeserializer(collectionType, typeDeserializer, jsonDeserializer);
        }
        if (Multiset.class.isAssignableFrom(clazz)) {
            if (LinkedHashMultiset.class.isAssignableFrom(clazz)) {
                return new LinkedHashMultisetDeserializer(collectionType, typeDeserializer, jsonDeserializer);
            }
            if (HashMultiset.class.isAssignableFrom(clazz)) {
                return new HashMultisetDeserializer(collectionType, typeDeserializer, jsonDeserializer);
            }
            if (EnumMultiset.class.isAssignableFrom(clazz)) {
                // empty if block
            }
            if (TreeMultiset.class.isAssignableFrom(clazz)) {
                return new TreeMultisetDeserializer(collectionType, typeDeserializer, jsonDeserializer);
            }
            return new HashMultisetDeserializer(collectionType, typeDeserializer, jsonDeserializer);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findMapDeserializer(MapType mapType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        Class<?> clazz = mapType.getRawClass();
        if (ImmutableMap.class.isAssignableFrom(clazz)) {
            if (ImmutableSortedMap.class.isAssignableFrom(clazz)) {
                return new ImmutableSortedMapDeserializer(mapType, keyDeserializer, typeDeserializer, jsonDeserializer);
            }
            if (ImmutableBiMap.class.isAssignableFrom(clazz)) {
                return new ImmutableBiMapDeserializer(mapType, keyDeserializer, typeDeserializer, jsonDeserializer);
            }
            return new ImmutableMapDeserializer(mapType, keyDeserializer, typeDeserializer, jsonDeserializer);
        }
        if (BiMap.class.isAssignableFrom(clazz)) {
            if (EnumBiMap.class.isAssignableFrom(clazz)) {
                // empty if block
            }
            if (EnumHashBiMap.class.isAssignableFrom(clazz)) {
                // empty if block
            }
            if (HashBiMap.class.isAssignableFrom(clazz)) {
                // empty if block
            }
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType mapLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        Class<?> clazz = mapLikeType.getRawClass();
        if (ListMultimap.class.isAssignableFrom(clazz)) {
            if (ImmutableListMultimap.class.isAssignableFrom(clazz)) {
                // empty if block
            }
            if (ArrayListMultimap.class.isAssignableFrom(clazz)) {
                return new ArrayListMultimapDeserializer(mapLikeType, keyDeserializer, typeDeserializer, jsonDeserializer);
            }
            if (LinkedListMultimap.class.isAssignableFrom(clazz)) {
                return new LinkedListMultimapDeserializer(mapLikeType, keyDeserializer, typeDeserializer, jsonDeserializer);
            }
            if (ForwardingListMultimap.class.isAssignableFrom(clazz)) {
                // empty if block
            }
            return new ArrayListMultimapDeserializer(mapLikeType, keyDeserializer, typeDeserializer, jsonDeserializer);
        }
        if (SetMultimap.class.isAssignableFrom(clazz)) {
            if (SortedSetMultimap.class.isAssignableFrom(clazz)) {
                if (TreeMultimap.class.isAssignableFrom(clazz)) {
                    // empty if block
                }
                if (ForwardingSortedSetMultimap.class.isAssignableFrom(clazz)) {
                    // empty if block
                }
            }
            if (ImmutableSetMultimap.class.isAssignableFrom(clazz)) {
                // empty if block
            }
            if (HashMultimap.class.isAssignableFrom(clazz)) {
                return new HashMultimapDeserializer(mapLikeType, keyDeserializer, typeDeserializer, jsonDeserializer);
            }
            if (LinkedHashMultimap.class.isAssignableFrom(clazz)) {
                return new LinkedHashMultimapDeserializer(mapLikeType, keyDeserializer, typeDeserializer, jsonDeserializer);
            }
            if (ForwardingSetMultimap.class.isAssignableFrom(clazz)) {
                // empty if block
            }
            return new HashMultimapDeserializer(mapLikeType, keyDeserializer, typeDeserializer, jsonDeserializer);
        }
        if (Multimap.class.isAssignableFrom(clazz)) {
            return new LinkedListMultimapDeserializer(mapLikeType, keyDeserializer, typeDeserializer, jsonDeserializer);
        }
        if (Table.class.isAssignableFrom(clazz)) {
            // empty if block
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (Optional.class.isAssignableFrom(clazz)) {
            return new GuavaOptionalDeserializer(javaType);
        }
        return super.findBeanDeserializer(javaType, deserializationConfig, beanDescription);
    }
}

